#ifndef VERSION
 #include <jabberd.h>
#endif

#include "libxg.h"

void xmlnode_move_node(xmlnode loNode, xmlnode loParentOld, xmlnode loParentNew)
   {
   if (loParentOld==NULL || loParentNew==NULL)
      return;


   xmlnode_hide(loNode);
   loNode->next=loNode->prev=NULL;
 
   if (loParentNew->firstchild==NULL)
      loParentNew->firstchild=loNode;
   else
      {
      loNode->next=loParentNew->firstchild;
      loParentNew->firstchild->prev=loNode;
      loParentNew->firstchild=loNode;
      }

   if (loParentNew->lastchild==NULL)
      loParentNew->lastchild=loNode;

   loNode->parent = loParentNew; // change parent of node
   }

void _xmlnode_mergeX(pool p,xmlnode data)
   {
    xmlnode cur;
    char *merge, *scur;
    int imerge;
    pool px;

    if (p==NULL)
       px=data->p;
    else
       px=p;


    /* get total size of all merged cdata */
    imerge = 0;
    for(cur = data; cur != NULL && cur->type == NTYPE_CDATA; cur = cur->next)
        imerge += cur->data_sz;

    /* copy in current data and then spin through all of them and merge */
    scur = merge = pmalloc(px,imerge + 1);
    for(cur = data; cur != NULL && cur->type == NTYPE_CDATA; cur = cur->next)
    {
        memcpy(scur,cur->data,cur->data_sz);
        scur += cur->data_sz;
    }
    *scur = '\0';

    /* this effectively hides all of the merged-in chunks */
    data->next = cur;
    if(cur == NULL)
        data->parent->lastchild = data;
    else
        cur->prev = data;

    /* reset data */
    data->data = merge;
    data->data_sz = imerge;
    
   }

char* xmlnode_get_data_pool(pool p,xmlnode node)
   {
    if(xmlnode_get_type(node) == NTYPE_TAG) /* loop till we find a CDATA in the children */
        for(node = xmlnode_get_firstchild(node); node != NULL; node = xmlnode_get_nextsibling(node))
            if(xmlnode_get_type(node) == NTYPE_CDATA) break;

    if(node == NULL) return NULL;

    /* check for a dirty node w/ unassembled cdata chunks */
    if(xmlnode_get_type(node->next) == NTYPE_CDATA)
        _xmlnode_mergeX(p,node);

    return node->data;
   }



char* spool_print_pool(pool p,spool s)
   {
    char *ret,*tmp;
    struct spool_node *next;
    pool px;

    if(s == NULL || s->len == 0 || s->first == NULL)
        return NULL;

    if (p==NULL)
       px=s->p;
    else
       px=p;


    ret = pmalloc(px, s->len + 1);
    *ret = '\0';

    next = s->first;
    tmp = ret;
    while(next != NULL)
    {
        tmp = j_strcat(tmp,next->c);
        next = next->next;
    }

    return ret;
   }

spool spool_dup_pool(pool p,spool s)
   {
   spool sret;
   struct spool_node *next;

   if(s == NULL || s->len == 0 || s->first == NULL)
      return (spool) NULL;

   sret = spool_new(p);

   next = s->first;
   while(next != NULL)
       {
       spool_add(sret,next->c);
       next = next->next;
       }

   return sret;
   }

spool spool_dup(spool s)
   {
   spool sret;
   pool p=pool_new();
   struct spool_node *next;

   if(s == NULL || s->len == 0 || s->first == NULL)
      return (spool) NULL;

   sret = spool_new(p);

   next = s->first;
   while(next != NULL)
       {
       spool_add(sret,next->c);
       next = next->next;
       }

   return sret;
   }

dpacket dpacket_copy_pool(pool p, dpacket dp)
{
    dpacket p2;

    p2 = dpacket_new(xmlnode_dup_pool(p,dp->x));
    return p2;
}

void _xmlnode_tag2str(spool s, xmlnode node, int flag)
{
    xmlnode tmp;

    if(flag==0 || flag==1)
    {
	    spooler(s,"<",xmlnode_get_name(node),s);
	    tmp = xmlnode_get_firstattrib(node);
	    while(tmp) {
	        spooler(s," ",xmlnode_get_name(tmp),"='",strescape(xmlnode_pool(node),xmlnode_get_data(tmp)),"'",s);
	        tmp = xmlnode_get_nextsibling(tmp);
	    }
	    if(flag==0)
	        spool_add(s,"/>");
	    else
	        spool_add(s,">");
    }
    else
    {
	    spooler(s,"</",xmlnode_get_name(node),">",s);
    }
}

spool _xmlnode2spool(pool p,xmlnode node)
{
    spool s;
    int level=0,dir=0;
    xmlnode tmp;

    if(!node || xmlnode_get_type(node)!=NTYPE_TAG)
        return NULL;

    if (!p)
       s = spool_new(xmlnode_pool(node));
    else
       s = spool_new(p);

    if(!s) return(NULL);

    while(1)
    {
        if(dir==0)
        {
    	    if(xmlnode_get_type(node) == NTYPE_TAG)
            {
                if(xmlnode_has_children(node))
                {
                    _xmlnode_tag2str(s,node,1);
                    node = xmlnode_get_firstchild(node);
                    level++;
                    continue;
                }else{
                    _xmlnode_tag2str(s,node,0);
                }
            }else{
                spool_add(s,strescape(xmlnode_pool(node),xmlnode_get_data(node)));
            }
        }

    	tmp = xmlnode_get_nextsibling(node);
        if(!tmp)
        {
            node = xmlnode_get_parent(node);
            level--;
            if(level>=0) _xmlnode_tag2str(s,node,2);
//            if(level<1) break; // bad place
            dir = 1;
        }else{
            node = tmp;
            dir = 0;
        }
        if(level<1) break; // right place
    }

    return s;
}

char *xmlnode2str_fix(xmlnode node)
{
     return spool_print(_xmlnode2spool((pool)NULL,node));
}


char *xmlnode2str_pool(pool p,xmlnode node)
   {
   return spool_print(_xmlnode2spool(p,node));
   }
