#include "smtp.h"

extern smtpi jtin;

void smtp_out_packets_mtq(void *arg)
   {
   char *lcType;
   int liProcess=0,liCBS;
   xmlnode loJID,x;
   smtpp par=(smtpp) arg;
   dpacket dp=par->dp;
   instance i=par->i;
   pool p=par->tmppool;
   jpacket jp;

   par->jp=jp=jpacket_new(dp->x);
   jpacket_subtype(jp);

   // if get error packet and to=from, throw it
   if (jp->subtype == JPACKET__ERROR && j_strcmp(xmlnode_get_attrib(jp->x,"from"),xmlnode_get_attrib(jp->x,"to"))==0 )
      liProcess=-1;

   // Run hook callback functions 
   if (liProcess==0)
      liCBS=HJPM_RunCBF(xmlnode_get_attrib(jp->x,"id"),jp);

   if (liProcess==0 && liCBS==HJPM_MODE_CBFSP)
      {
      // read the language from AI (account information)
      loJID=SMTP_GetItemRoster(smtp_GetJID(p,xmlnode_get_attrib(jp->x,"from")),1);
      if (loJID!=NULL)
         par->lang=xmlnode_get_attrib(loJID,"lang");

      // if language not defined, get lang from packet
      if (par->lang==NULL)
         par->lang=xmlnode_get_attrib(jp->x, "xml:lang");

      // if language not defined, get smtp default language
      if (par->lang==NULL)
         par->lang=jtin->DefaultLang;


      /* XXX check and make sure it's a message and stuff */
      lcType=xmlnode_get_attrib(jp->x,"type");

      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"smtp getting a packet: %i, %i",jp->type,jp->subtype);
      #endif
      switch(jp->type)
         {
         // is it message?
         case JPACKET_MESSAGE:
              if (j_atoi(xmlnode_get_attrib(xmlnode_get_tag(jtin->configr,"jabber"),"state"),0)==0)
                 {
                 x= out_SetReply(xmlnode_new_tag("presence"),jp->x);
                 PM_Reg(310, NULL,xmlnode_pool(x),1,NULL);

                 xmlnode_insert_cdata(xmlnode_insert_tag(x,"show"),"online",-1);
                 xmlnode_insert_cdata(xmlnode_insert_tag(x,"status"),smtp_rc_GetString(p,par->lang,SMTP_XXX_JABBER_SUSPEND),-1);
                 deliver(dpacket_new(xmlnode_dup(x)),par->i);
                 smtp_stats_out(x);
                 xmlnode_free(x);
                 liProcess=1;
                 }
              else
                 {
                 if ((liProcess=smtp_out_packets_message(par,(char *)lcType))==0)
                    smtp_ReplyError(i, jp, "message", "Not Implemented", 501);
                 }
 
              break;


         // is it presence?
         case JPACKET_PRESENCE:
              if ((liProcess=smtp_out_packets_presence(par,(char *)lcType))==0)
                 smtp_ReplyError(i, jp, "presence", "Not Implemented", 501);

              break;


         // is it presence(x)?
         case JPACKET_S10N:
              if ((liProcess=smtp_out_packets_S10N(par,(char *)lcType))==0)
                 smtp_ReplyError(i, jp, "presence", "Not Implemented", 501);

              break;

         // is it iq?
         case JPACKET_IQ:
              if ((liProcess=smtp_out_packets_iq(par, (char *)lcType))==0)
                 smtp_ReplyError(i, jp, "iq", "Not Implemented", 501);

              break;

       
         // is it unknown packet?
         case JPACKET_UNKNOWN:
              break;

         }
      }

   smtp_stats_in(jp->x);

   if (liProcess!=-2) // uvolnn poolu provede jin procedura
      {
      par->dp=NULL;
      par->i=NULL;
      par->lang=NULL;
      pool_free(p);
      }

   return;
   }


// S:2005-09-01 gorila@dione.zcu.cz
result smtp_out_packets(instance i, dpacket dp, void *arg)
   {
   smtpp par;
   pool p;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"smtp getting a packet: %s",xmlnode2str(dp->x));
   #endif

   p=pool_new();   
   PM_Reg(300,NULL, p,1,NULL);
   par= smtp_param_i(p,i);

   par->dp=dpacket_copy_pool(p, dp);
   par->q=mtq_new(p);
   mtq_send(par->q, p, smtp_out_packets_mtq, (void *)par);

   return r_DONE;
   }
// E:2005-09-01 gorila@dione.zcu.cz
