#include "smtp.h"
extern smtpi jtin;

int smtp_out_packets_iq_di_jid(smtpp par, char *type)
   {

   int liProcess=0,liStart=0,liAdmin,liComplete=0;
   jpacket jp=par->jp;

   xmlnode loQuery, loIdentity,loItem,loCmd,loNode,xData,loNData,loJID,loCommand,loActions;
   smtp_jq loQueue=NULL;
   smtp_jq_x loData;
   char *lcLang,*lcJID,*lcAction,*lcNode,*lcSessionID,*lcTo;
   pool p=par->tmppool;
   time_t now_unixtime;
   struct tm now;
   smtp_jcmdq loCmdQ;

   lcLang=par->lang;
   lcJID=smtp_GetJID(p,jid_full(jp->from));
   lcTo=smtp_GetJID(p,jid_full(jp->to));
   lcNode=xmlnode_get_attrib(jp->iq,"node");
   liAdmin=_smtp_opm_check_JID(lcJID,SMTP_ADMIN_NS_TRANSPORT);
   
   if (liProcess==0 && j_strcmp(jp->iqns,NS_DISCO_INFO)==0 && jp->subtype==JPACKET__RESULT)
      {

      }


   if (liProcess==0 &&
       j_strcmp(jp->iqns,NS_DISCO_INFO)==0 &&
       jp->subtype==JPACKET__GET &&
       j_strlen(lcNode)==0
      )
      {
      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2220, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",jp->iqns);
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_DISCO_INFO);

      xmlnode_put_attrib(loIdentity=xmlnode_insert_tag(loQuery,"identity"),"category","client");
      xmlnode_put_attrib(loIdentity,"name",smtp_contact);

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_VCARD);
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_CAPS);
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_XHTML_IM);
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_DISCO_ITEMS);
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_COMMANDS);
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_XMPP_PING);

      liProcess=1;
      }

   // **************************************
   // xmpp - ping
   // **************************************
   if (liProcess==0 && j_strcmp(jp->iqns,NS_XMPP_PING)==0 && jp->subtype==JPACKET__GET)
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2215, NULL, xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");
      liProcess=1;
      }

   if (liProcess==0 &&
       j_strcmp(jp->iqns,NS_DISCO_INFO)==0 &&
       jp->subtype==JPACKET__GET &&
       j_strcmp(lcNode,NS_COMMANDS)==0
      )
      {
      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2225, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",jp->iqns);
      xmlnode_put_attrib(loQuery,"node",lcNode);

      xmlnode_put_attrib(loIdentity=xmlnode_insert_tag(loQuery,"identity"),"category","automation");
      xmlnode_put_attrib(loIdentity,"type","command-list");
      xmlnode_put_attrib(loIdentity,"name",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1000));

      liProcess=1;
      }


   // **************************************
   // basic disco#items
   // disco#items Get branch
   // **************************************
   if (liProcess==0 && jp->subtype==JPACKET__GET && 
       j_strcmp(jp->iqns,NS_DISCO_ITEMS)==0 &&
       j_strlen(lcNode)==0
      )
      {
      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2230,NULL, xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",jp->iqns);

      xmlnode_put_attrib(loItem=xmlnode_insert_tag(loQuery,"item"),"jid",lcTo);
      xmlnode_put_attrib(loItem,"name",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1010));
      xmlnode_put_attrib(loItem,"node","settings");

      liProcess=1;
      }


   // settings, reports, etc. info
   if (liProcess==0 && jp->subtype==JPACKET__GET && 
       j_strcmp(jp->iqns,NS_DISCO_INFO)==0 &&
       (j_strcmp(lcNode,"settings")==0)
      )
      {
      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2240, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",jp->iqns);
      xmlnode_put_attrib(loQuery,"node",lcNode);

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_DISCO_INFO);

      xmlnode_put_attrib(loIdentity=xmlnode_insert_tag(loQuery,"identity"),"category","automation");
      xmlnode_put_attrib(loIdentity,"type","command-list");

      xmlnode_put_attrib(loIdentity,"name",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1010));

      liProcess=1;
      }



   // settings - items
   if (liProcess==0 && jp->subtype==JPACKET__GET &&
      (
       (j_strcmp(jp->iqns,NS_DISCO_ITEMS)==0 &&
       j_strcmp(lcNode,"settings")==0) ||
       (j_strcmp(jp->iqns,NS_DISCO_ITEMS)==0 &&
       j_strcmp(lcNode,NS_COMMANDS)==0)
      )
      )
      {
      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2250, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",jp->iqns);
      xmlnode_put_attrib(loQuery,"node",lcNode);

      xmlnode_put_attrib(loItem=xmlnode_insert_tag(loQuery,"item"),"jid",lcTo);
      xmlnode_put_attrib(loItem,"name",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1050));
      xmlnode_put_attrib(loItem,"node","settings/general");

      xmlnode_put_attrib(loItem=xmlnode_insert_tag(loQuery,"item"),"jid",lcTo);
      xmlnode_put_attrib(loItem,"name",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1060));
      xmlnode_put_attrib(loItem,"node","settings/j2s");

      xmlnode_put_attrib(loItem=xmlnode_insert_tag(loQuery,"item"),"jid",lcTo);
      xmlnode_put_attrib(loItem,"name",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1070));
      xmlnode_put_attrib(loItem,"node","settings/s2j");

      liProcess=1;
      }

   // settings - items info
   if (liProcess==0 && jp->subtype==JPACKET__GET && 
       j_strcmp(jp->iqns,NS_DISCO_INFO)==0 &&
       strncmp("settings/",lcNode,9)==0
      )
      {
      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2260, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",jp->iqns);
      xmlnode_put_attrib(loQuery,"node",lcNode);

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_DISCO_INFO);
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var",NS_COMMANDS);

      xmlnode_put_attrib(loIdentity=xmlnode_insert_tag(loQuery,"identity"),"category","automation");
      xmlnode_put_attrib(loIdentity,"type","command-node");

      if (j_strcmp(lcNode,"settings/general")==0)
         xmlnode_put_attrib(loIdentity,"name",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1050));
      else if (j_strcmp(lcNode,"settings/j2s")==0)
         xmlnode_put_attrib(loIdentity,"name",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1060));
      else if (j_strcmp(lcNode,"settings/s2j")==0)
         xmlnode_put_attrib(loIdentity,"name",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1070));

      liProcess=1;
      }


   // no items for:
   // adminreports/memory - items
   if (liProcess==0 && jp->subtype==JPACKET__GET && 
       j_strcmp(jp->iqns,NS_DISCO_ITEMS)==0 &&
       (j_strcmp(lcNode,"settings/general")==0 ||
        j_strcmp(lcNode,"settings/s2j")==0 ||
        j_strcmp(lcNode,"settings/j2s")==0
       )
      )
      {

      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2272, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",jp->iqns);
      xmlnode_put_attrib(loQuery,"node",lcNode);

      liProcess=1;
      }



   // =================================================
   // command execute section
   loCommand=xmlnode_get_tag(jp->x,"command");
   lcAction=xmlnode_get_attrib(loCommand,"action");
   lcNode= xmlnode_get_attrib(loCommand,"node");
   lcSessionID=xmlnode_get_attrib(loCommand,"sessionid");

   //
   //
   //
   if (liProcess==0 && xmlnode_get_tag(loCommand,"x?type=submit")!=NULL &&  smtp_CmdGet(lcSessionID)==NULL)
      {
      liProcess=-1;
      }


   // cancel mode
   if (liProcess==0 && jp->subtype==JPACKET__SET && 
       j_strcmp(xmlnode_get_attrib(loCommand,"xmlns"),NS_COMMANDS)==0 &&
       j_strcmp(lcAction,"cancel")==0
      )
      {

      xData=xmlnode_get_tag(loCommand,"x");
      lcJID=smtp_GetJID(p,xmlnode_get_attrib(jp->x,"from"));

      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2290,NULL, xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loCmd=xmlnode_insert_tag(loData->x,"command"),"xmlns",NS_COMMANDS);
      xmlnode_put_attrib(loCmd,"sessionid",xmlnode_get_attrib(loCommand,"sessionid"));
      xmlnode_put_attrib(loCmd,"node",lcNode);
      xmlnode_put_attrib(loCmd,"status","canceled");
      xmlnode_put_attrib(loNode=xmlnode_insert_tag(loCmd,"note"),"type","info");
      xmlnode_insert_cdata(loNode,smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1900),-1);

      lcSessionID=xmlnode_get_attrib(loCommand,"sessionid");
      xmlnode_put_attrib(loNData=xmlnode_insert_tag(loCmd,"x"),"xmlns",NS_DATA);

      xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"title"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1910),-1);
      xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"instructions"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1920),-1);

      if (j_strlen(lcSessionID)>0)
         smtp_CmdDel(lcSessionID);
         
      liProcess=1;
      }

   loCmdQ=smtp_CmdGet(lcSessionID);

   // execute mode (and prev and next)
   if (liProcess==0 && jp->subtype==JPACKET__SET && 
       j_strcmp(xmlnode_get_attrib(loCommand,"xmlns"),NS_COMMANDS)==0 &&
       (j_strcmp(lcAction,"execute")==0 || j_strcmp(lcAction,"next")==0 ||
        j_strcmp(lcAction,"prev")==0 || j_strlen(lcAction)==0) &&
       ((loCmdQ!=NULL && loCmdQ->iLevel<=loCmdQ->iMaxLevel) || loCmdQ==NULL)
      )
      {
      xData=xmlnode_get_tag(loCommand,"x");

      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2210, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      lcJID=smtp_GetJID(p,xmlnode_get_attrib(jp->x,"from"));

      xmlnode_put_attrib(loCmd=xmlnode_insert_tag(loData->x,"command"),"xmlns",NS_COMMANDS);
      if (j_strlen(lcSessionID)==0)
         {
         now_unixtime = time(NULL);
         gmtime_r(&now_unixtime, &now);
         lcSessionID=(char*)pmalloc_x(p, 30,'\0');
         snprintf(lcSessionID, 30, "XC_%04i%02i%02i%02i%02i%02i%i\0", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
         liStart=1;
         }

      if (liStart==1)
         {
         smtp_CmdAppend(loCmdQ=smtp_CmdNew());
         loCmdQ->cSessionID=pstrdup(loCmdQ->p,lcSessionID);
         loCmdQ->iMaxLevel=0;
         }
      else
         loCmdQ=smtp_CmdGet(lcSessionID);


      xmlnode_put_attrib(loCmd,"sessionid",lcSessionID);

      xmlnode_put_attrib(loCmd,"node",lcNode);
      xmlnode_put_attrib(loCmd,"status","executing");
      loActions=xmlnode_insert_tag(loCmd,"actions");

      xmlnode_put_attrib(loNData=xmlnode_insert_tag(loCmd,"x"),"xmlns",NS_DATA);

      if (j_strcmp(lcNode,"settings/general")==0)
         {
         xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"title"),smtp_rc_GetString(p,lcLang,SMTP_RC_GLOBAL_TITLE),-1);
         xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"instructions"),smtp_rc_GetString(p,lcLang,SMTP_RC_GLOBAL_DATA),-1);
         
         loJID=smtp_online_get_item(lcJID, smtp_GetJID(par->tmppool,jid_full(jp->to)),1);
         smtp_opiqr_FillDataFromJID(p, "account", loNData,loJID,lcLang);
         xmlnode_free(loJID);

         xmlnode_put_attrib(loActions,"execute","next");
         xmlnode_insert_tag(loActions,"complete");
         loCmdQ->iLevel++;
         liProcess=1;
         }

      if (j_strcmp(lcNode,"settings/j2s")==0)
         {
         xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"title"),smtp_rc_GetString(p,lcLang,SMTP_RC_J2S_TITLE),-1);
         xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"instructions"),smtp_rc_GetString(p,lcLang,SMTP_RC_J2S_DATA),-1);
         loJID=smtp_online_get_item(lcJID, smtp_GetJID(par->tmppool,jid_full(jp->to)),1);
         smtp_opiqr_FillDataFromJID(p, "cj2s", loNData,loJID,lcLang);
         xmlnode_free(loJID);

         xmlnode_put_attrib(loActions,"execute","next");
         xmlnode_insert_tag(loActions,"complete");
         loCmdQ->iLevel++;
         liProcess=1;
         }

      if (j_strcmp(lcNode,"settings/s2j")==0)
         {
         xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"title"),smtp_rc_GetString(p,lcLang,SMTP_RC_S2J_TITLE),-1);
         xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"instructions"),smtp_rc_GetString(p,lcLang,SMTP_RC_S2J_DATA),-1);
         loJID=smtp_online_get_item(lcJID, smtp_GetJID(par->tmppool,jid_full(jp->to)),1);
         smtp_opiqr_FillDataFromJID(p, "cs2j", loNData,loJID,lcLang);
         xmlnode_free(loJID);

         xmlnode_put_attrib(loActions,"execute","next");
         xmlnode_insert_tag(loActions,"complete");
         loCmdQ->iLevel++;
         liProcess=1;
         }
      }


   // finish mode
   if (liProcess==0 && jp->subtype==JPACKET__SET && 
       j_strcmp(xmlnode_get_attrib(loCommand,"xmlns"),NS_COMMANDS)==0 &&
       (j_strcmp(lcAction,"complete")==0 || liComplete==1 || (loCmdQ!=NULL && loCmdQ->iLevel>=loCmdQ->iMaxLevel))
      )
      {

      xData=xmlnode_get_tag(loCommand,"x");
      lcJID=smtp_GetJID(p,xmlnode_get_attrib(jp->x,"from"));

      loQueue=smtp_NewQueueItem(p,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(2280, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loCmd=xmlnode_insert_tag(loData->x,"command"),"xmlns",NS_COMMANDS);
      xmlnode_put_attrib(loCmd,"sessionid",xmlnode_get_attrib(loCommand,"sessionid"));
      xmlnode_put_attrib(loCmd,"node",lcNode);
      xmlnode_put_attrib(loCmd,"status","completed");
      xmlnode_put_attrib(loNode=xmlnode_insert_tag(loCmd,"note"),"type","info");
      xmlnode_insert_cdata(loNode,smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1820),-1);

      lcSessionID=xmlnode_get_attrib(loCommand,"sessionid");
      xmlnode_put_attrib(loNData=xmlnode_insert_tag(loCmd,"x"),"xmlns",NS_DATA);

      if (strncmp("settings/",lcNode,9)==0)
         {
         if (j_strcmp(lcNode,"settings/general")==0)
            {
            xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"title"),smtp_rc_GetString(p,lcLang,SMTP_RC_GLOBAL_TITLE),-1);
            xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"instructions"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1830),-1);
            }
         else if (j_strcmp(lcNode,"settings/j2s")==0)
            {
            xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"title"),smtp_rc_GetString(p,lcLang,SMTP_RC_J2S_TITLE),-1);
            xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"instructions"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1840),-1);
            }
         else if (j_strcmp(lcNode,"settings/s2j")==0)
            {
            xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"title"),smtp_rc_GetString(p,lcLang,SMTP_RC_S2J_TITLE),-1);
            xmlnode_insert_cdata(xmlnode_insert_tag(loNData,"instructions"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_1850),-1);
            }

         loJID=smtp_online_get_item(lcJID, smtp_GetJID(par->tmppool,jid_full(jp->to)),1);
         smtp_opiqr_SaveToJID(xData,loJID);
         smtp_online_set_item(lcJID,loJID);
         xmlnode_free(loJID);
         }


      // remove command from queue
      if (j_strlen(lcSessionID)>0)
         smtp_CmdDel(lcSessionID);

      liProcess=1;
      }


   if (liProcess==1)
      smtp_FlushQueue(par->i, loQueue);
   else
      smtp_ClearQueue(loQueue);

   return liProcess;
   }


