#include "smtp.h"
extern smtpi jtin;


int smtp_out_packets_iq_gateway(smtpp par, char *type)
   {
   int liProcess=0;
   jpacket jp=par->jp;
   char *lcJID, *lcPercent,*lcAT,*lcLang;
   xmlnode loQuery;
   smtp_jq loQueue;
   smtp_jq_x loData;


   lcLang=par->lang;

   if (liProcess==0 && j_strcmp(jp->iqns,NS_GATEWAY)==0 && jp->subtype==JPACKET__GET && jp->to->user==NULL)
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1200, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_GATEWAY);


      xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"desc"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_GATEWAY_DESCR),-1);
      xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"prompt"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_GATEWAY_PROMPT),-1);

      liProcess=1;
      }


   if (liProcess==0 && j_strcmp(jp->iqns,NS_GATEWAY)==0 && jp->subtype==JPACKET__SET && jp->to->user==NULL)
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1210,NULL, xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");


      // check prompt element data
      /* translate the recipient into a SMTP address */
      lcJID = smtp_alltrim(xmlnode_get_data(xmlnode_get_tag(jp->x,"query/prompt")));
      lcPercent = strstr(lcJID,"%");
      lcAT = strstr(lcJID,"@");
      
      if (lcPercent==NULL && lcAT==NULL)
         smtp_ReplyError(par->i, jp, "iq", "Bad address", 405);
      else
         {
         if (lcPercent!=NULL && lcAT!=NULL) // define % and @
            {
            if (lcPercent<lcAT) // % is before @
               *lcAT='\0';
            else
               {
               *lcPercent='\0';
               *lcAT='%';
               }
            }
         else    
            if (lcAT!=NULL)
               *lcAT='%';

         *lcAT='\0';
         if (j_strlen(lcAT+1)==0 || j_strlen(lcJID)==0)
            smtp_ReplyError(par->i, jp, "iq", "Bad address", 405);
         else
            {
            *lcAT='%';
            xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_GATEWAY);
            xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"prompt"),strcat(strcat(lcJID,"@"),xmlnode_get_attrib(jp->x,"to")),-1);
            }
         }

      liProcess=1;
      }

   if (liProcess==1)
      smtp_FlushQueue(par->i, loQueue);


   return liProcess;
   }
