#include "smtp.h"
extern smtpi jtin;


void smtp_opiqr_SaveToJID(xmlnode xData,xmlnode loJID)
   {
   xmlnode loField,loItem,loGL,loSL,loItemX;
   char *lcName,*lcVal,*lcN,*lcXXX;

   for (loField = xmlnode_get_firstchild(xData); loField != NULL; loField = xmlnode_get_nextsibling(loField))
       {
       if (loField->type!=NTYPE_TAG)
          continue;

       lcName=xmlnode_get_attrib(loField,"var");
       if (j_strcmp(lcName,"UseGlobalSettings")==0 ||
           j_strcmp(lcName,"UseAccountSettings")==0 ||
           j_strcmp(lcName,"SendSystemMessage")==0 ||
           j_strcmp(lcName,"Attachments")==0 ||
           j_strcmp(lcName,"PGPJabberToMIME")==0 ||
           j_strcmp(lcName,"PGPToJabbernonMIMETox")==0 ||
           j_strcmp(lcName,"J2S_SRMode")==0 ||
           j_strcmp(lcName,"J2S_SRSeparator")==0 ||
           j_strcmp(lcName,"J2S_SRText")==0 ||
           j_strcmp(lcName,"S2J_SRMode")==0 ||
           j_strcmp(lcName,"S2J_SRSeparator")==0 ||
           j_strcmp(lcName,"S2J_SRText")==0 ||
           j_strcmp(lcName,"S2J_OutputMode")==0 ||
           j_strcmp(lcName,"J2S_RTMode")==0 ||
           j_strcmp(lcName,"J2S_RTName")==0 ||
           j_strcmp(lcName,"J2S_RTAddr")==0 ||
           j_strcmp(lcName,"J2S_ASMode")==0 ||
           j_strcmp(lcName,"J2S_FRMode")==0 ||
           j_strcmp(lcName,"J2S_FRName")==0 ||
           j_strcmp(lcName,"J2S_FRAddr")==0 ||
           j_strcmp(lcName,"lang")==0 ||
           j_strcmp(lcName,"S2J_MailMode")==0  ||
           j_strcmp(lcName,"S2J_AllAreSPAM")==0
          )
          {
          lcVal=xmlnode_get_tag_data(loField,"value");
          if ((j_strcmp(lcName,"J2S_RTAddr")==0 ||
               j_strcmp(lcName,"J2S_SRSeparator")==0 ||
               j_strcmp(lcName,"J2S_SRText")==0 ||
               j_strcmp(lcName,"J2S_RTName")==0 ||
               j_strcmp(lcName,"J2S_RTAddr")==0 ||
               j_strcmp(lcName,"J2S_FRAddr")==0 ||
               j_strcmp(lcName,"J2S_FRName")==0 ||
               j_strcmp(lcName,"S2J_SRSeparator")==0 ||
               j_strcmp(lcName,"S2J_SRText")==0) && j_strlen(lcVal)==0
              )
             xmlnode_put_attrib(loJID,lcName," ");

          else
             xmlnode_put_attrib(loJID,lcName,xmlnode_get_tag_data(loField,"value"));
          }


       if (j_strcmp(lcName,"BlackList")==0)
          {
          loGL=xmlnode_get_tag(loJID,"graylist");
          xmlnode_hide(loGL);
          loGL->next=loGL->prev=NULL; // fix bug in xmlnode_hide()

          loSL=xmlnode_insert_tag(loJID,"graylist");

          for (loItem = xmlnode_get_firstchild(loField); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
              {
              if (loItem->type!=NTYPE_TAG || j_strlen(xmlnode_get_data(loItem))==0)
                 continue;

              xmlnode_put_attrib(loItemX=xmlnode_insert_tag(loSL,"item"),"ip",xmlnode_get_data(loItem));
              xmlnode_put_attrib(loItemX,"mode","1");
              }

          // now copy items with mode=0 (white list) from original greylist
          for (loItem = xmlnode_get_firstchild(loGL); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
              {
              if (loItem->type==NTYPE_TAG && j_atoi(xmlnode_get_attrib(loItem,"mode"),1)==0)
                 xmlnode_insert_tag_node(loSL,loItem);
              }


          }


       if (j_strcmp(lcName,"WhiteList")==0)
          {
          loGL=xmlnode_get_tag(loJID,"graylist");
          xmlnode_hide(loGL);
          loGL->next=loGL->prev=NULL; // fix bug in xmlnode_hide()

          loSL=xmlnode_insert_tag(loJID,"graylist");

          // now copy items with mode=1 (Black list) from original greylist
          for (loItem = xmlnode_get_firstchild(loGL); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
              {
              if (loItem->type==NTYPE_TAG && j_atoi(xmlnode_get_attrib(loItem,"mode"),1)==1)
                  xmlnode_insert_tag_node(loSL,loItem);
              }

          for (loItem = xmlnode_get_firstchild(loField); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
              {
              if (loItem->type!=NTYPE_TAG || j_strlen(xmlnode_get_data(loItem))==0)
                 continue;

              xmlnode_put_attrib(loItemX=xmlnode_insert_tag(loSL,"item"),"ip",xmlnode_get_data(loItem));
              xmlnode_put_attrib(loItemX,"mode","0");
              }

          }

       if (j_strcmp(lcName,"AutoSignature")==0)
          {
          loSL=xmlnode_get_tag(loJID,"autosignature");
          xmlnode_hide(loSL);
          loSL=xmlnode_insert_tag(loJID,"autosignature");

          for (loItem = xmlnode_get_firstchild(loField); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
              {
              if (loItem->type!=NTYPE_TAG)
                 continue;

              lcVal=xmlnode_get_data(loItem);
              if (j_strlen(lcVal)==0)
                 {
                 xmlnode_insert_tag(loSL,"item");
                 continue;
                 }

              lcXXX=lcVal+j_strlen(lcVal)-1;

              while ((lcN=strchr(lcVal,'\n'))!=NULL)
                 {
                 *lcN='\0';
                 xmlnode_insert_cdata(xmlnode_insert_tag(loSL,"item"),lcVal,-1);
                 lcVal=lcN+1;
                 }
              if (lcVal<=lcXXX && strlen(lcVal)>0)
                 xmlnode_insert_cdata(xmlnode_insert_tag(loSL,"item"),lcVal,-1);
                 
              }
          }
       }
   }

void smtp_opiqr_FillDataFromJID(pool p, const char *lcGroup,xmlnode xData,xmlnode loJID,char *lcLang)
   {
   xmlnode loField,loOption,loItem,loLang;
   char *lcVal,*lcPom;
   int liPom;

   liPom=1024;
   lcPom = (char*)pmalloc_x(p, liPom+1,' ');
   lcPom[liPom] = '\0';

   // global settings
   if (j_strcmp(lcGroup,"Rglobal")==0 || j_strcmp(lcGroup,"global")==0)
      {
      xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
      xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_USEGLOBALSETTINGS_LBL));
      xmlnode_put_attrib(loField,"var","UseGlobalSettings");

      xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"UseGlobalSettings"),-1);
      xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_USEGLOBALSETTINGS_DSC),-1);


	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2170));
	  xmlnode_put_attrib(loField,"var","lang");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2180),-1);

      xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),lcLang,-1);
  
      for (loLang = xmlnode_get_tag(jtin->resources,"strings/lang"); loLang != NULL; loLang = xmlnode_get_nextsibling(loLang))
          {
          if (loLang->type!=NTYPE_TAG)
              continue;

          xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",xmlnode_get_attrib(loLang,"xml:lang"));
	      xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),xmlnode_get_attrib(loLang,"xml:lang"),-1);
          }



      // sendsystemmessage
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2190));
	  xmlnode_put_attrib(loField,"var","SendSystemMessage");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2200),-1);

	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"SendSystemMessage"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2210));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2220));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2230));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2240));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"3",-1);

      // VIP Mode - ReadOnly
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_put_attrib(loField,"var","VIP-RO");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2370),-1);

      if (j_atoi(xmlnode_get_attrib(loJID,"paid"),0)==0)
         snprintf(lcPom, liPom, smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2360),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2390));
      else
         snprintf(lcPom, liPom, smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2360),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2380));
      xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),lcPom,-1);

      }

   if (j_strcmp(lcGroup,"Raccount")==0 || j_strcmp(lcGroup,"account")==0)
      {
      xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
      xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_USEACCOUNTSETTINGS_LBL));
      xmlnode_put_attrib(loField,"var","UseAcountSettings");

      xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"UseGlobalSettings"),-1);
      xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_USEACCOUNTSETTINGS_DSC),-1);
      }

   // j2s settings
   if (j_strcmp(lcGroup,"j2s")==0 || j_strcmp(lcGroup,"cj2s")==0)
      {
	  // own  setting - jabber to mime
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_PGPJABBERTOMIME_LBL));
	  xmlnode_put_attrib(loField,"var","PGPJabberToMIME");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"PGPJabberToMIME"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_PGPJABBERTOMIME_DSC),-1);



	  // own  setting - subject replace
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_HEAD),-1);

      // mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_SRMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_DSC),-1);

	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_SRMode"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL3_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"3",-1);


      // separator
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_SEPARATOR_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_SRSeparator");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_SRSeparator"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_SEP_DSC),-1);


      // text
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_TEXT_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_SRText");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_SRText"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_TXT_DSC),-1);


      // reply-to adrress (mode, name, addr)
      // mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_RT_DSC),-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_RT_MODE_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_RTMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_RTMode"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_RT_MODE_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_RT_MODE_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_RT_MODE_DSC),-1);

      // name
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_RT_NAME_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_RTName");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_RTName"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_RT_NAME_DSC),-1);

      // addr
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_RT_ADDR_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_RTAddr");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_RTAddr"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_RT_ADDR_DSC),-1);


      // from adrress (mode, name, addr)
      // mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_FR_DSC),-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_FR_MODE_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_FRMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_FRMode"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_FR_MODE_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_FR_MODE_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_FR_MODE_DSC),-1);

      // name
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_FR_NAME_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_FRName");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_FRName"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_FR_NAME_DSC),-1);

      // addr
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_FR_ADDR_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_FRAddr");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_FRAddr"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_FR_ADDR_DSC),-1);


      // auto signature mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_AS_DSC),-1);

      xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
      xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_AS_LBL));
      xmlnode_put_attrib(loField,"var","J2S_ASMode");
      xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_ASMode"),-1);

      // auto signature
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-multi");
      xmlnode_put_attrib(loField,"label","  ");
	  xmlnode_put_attrib(loField,"var","AutoSignature");
      for (loItem = xmlnode_get_firstchild(xmlnode_get_tag(loJID,"autosignature")); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
          {
          if (loItem->type!=NTYPE_TAG)
              continue;

          xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_data(loItem),-1);

          }
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_AS_DSC),-1);
      }

   // s2j settings
   if (j_strcmp(lcGroup,"s2j")==0 || j_strcmp(lcGroup,"cs2j")==0)
      {
      // own  setting - attachments
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_LBL));
	  xmlnode_put_attrib(loField,"var","Attachments");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"Attachments"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_DSC),-1);

	  // own  setting - to jabber non mime to x
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_PGPTOJABBERNONMIMETOX_LBL));
	  xmlnode_put_attrib(loField,"var","PGPToJabbernonMIMETox");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"PGPToJabbernonMIMETox"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_PGPTOJABBERNONMIMETOX_DSC),-1);
      }

   if (j_strcmp(lcGroup,"s2j")==0)
      {
	  // own  setting - all messages are spam
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ALLMESSAGESARESPAM_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_AllAreSPAM");
      lcVal=xmlnode_get_attrib(loJID,"S2J_AllAreSPAM");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),(j_strlen(lcVal)==0?"0":lcVal),-1);

	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ALLMESSAGESARESPAM_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ALLMESSAGESARESPAM_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ALLMESSAGESARESPAM_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);

	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_ALLMESSAGESARESPAM_DSC),-1);
      }

   if (j_strcmp(lcGroup,"s2j")==0 || j_strcmp(lcGroup,"cs2j")==0)
      {
	  // own  setting - subject replace
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_HEAD),-1);

      // mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_SRMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_SRMode"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL3_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"3",-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_DSC),-1);

      // separator
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_SEPARATOR_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_SRSeparator");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_SRSeparator"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_SEP_DSC),-1);

      // text
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_TEXT_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_SRText");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_SRText"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_SR_TXT_DSC),-1);


      // output mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2340));
	  xmlnode_put_attrib(loField,"var","S2J_OutputMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_OutputMode"),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2350),-1);

	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2310));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2320));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2330));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);


	  // Mail Mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2400));
	  xmlnode_put_attrib(loField,"var","S2J_MailMode");
      lcVal=xmlnode_get_attrib(loJID,"S2J_MailMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),(j_strlen(lcVal)==0?"0":lcVal),-1);

	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2410));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2420));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2440));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);

	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_ID_2430),-1);
      }

   // blacklist settings
   if (j_strcmp(lcGroup,"blacklist")==0)
      {
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-multi");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_BL_LBL));
	  xmlnode_put_attrib(loField,"var","BlackList");
      for (loItem = xmlnode_get_firstchild(xmlnode_get_tag(loJID,"graylist")); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
          {
          if (loItem->type!=NTYPE_TAG || j_atoi(xmlnode_get_attrib(loItem,"mode"),1)!=1)
              continue;

          xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loItem,"ip"),-1);

          }
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_BL_DSC),-1);
      }

   // whitelist settings
   if (j_strcmp(lcGroup,"whitelist")==0)
      {
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-multi");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_WL_LBL));
	  xmlnode_put_attrib(loField,"var","WhiteList");
      for (loItem = xmlnode_get_firstchild(xmlnode_get_tag(loJID,"graylist")); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
          {
          if (loItem->type!=NTYPE_TAG || j_atoi(xmlnode_get_attrib(loItem,"mode"),1)!=0)
              continue;

          xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loItem,"ip"),-1);

          }
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"desc"),smtp_rc_GetString(p,lcLang,SMTP_RC_REGISTER_WL_DSC),-1);
      }

   }

int smtp_out_packets_iq_register(smtpp par, char *type)
   {
   int liProcess=0,liDefault;
   jpacket jp=par->jp;
   char *lcJID, *lcLang;
   xmlnode loQuery, xData, loField, loJID,loInstruction;
   smtp_jq loQueue,loNextQ;
   smtp_jq_x loData;
   smtp_jq_cb loDataCB;


   lcLang=par->lang;

   // register service
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__GET)
      {
      /*
      Nati nastaven uivatele dle JID
      pokud neexistuje, pouij nastaven z konfigu transportu
      */
      lcJID=smtp_GetJID(par->tmppool,xmlnode_get_attrib(jp->x,"from"));
      loJID=SMTP_GetItemRoster(lcJID,1);
      liDefault=j_atoi(xmlnode_get_attrib(loJID,"default"),0);

      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1300,NULL, xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_REGISTER);

      if (liDefault==0) // user was registered
         xmlnode_insert_tag(loQuery,"registered");

	  xmlnode_insert_cdata(loInstruction=xmlnode_insert_tag(loQuery,"instruction"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_MAIN_I),-1);
      if (j_atoi(xmlnode_get_attrib(loJID,"paid"),0)==1)
         {
	     xmlnode_insert_cdata(loInstruction,"\r\n",-1);
	     xmlnode_insert_cdata(loInstruction,smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_PAID_LBL),-1);
         }

      xmlnode_put_attrib(xData=xmlnode_insert_tag(loQuery,"x"),"xmlns",NS_DATA);
	  xmlnode_insert_cdata(xmlnode_insert_tag(xData,"title"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_TITLE),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(xData,"instructions"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_DATA_I),-1);

      if (liDefault==0)
         {
         xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","hidden");
         xmlnode_put_attrib(loField,"var","FORM_TYPE");
         xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),NS_REGISTER,-1);
         }

      xmlnode_free(loJID);
      liProcess=1;
      }

   // unregister service
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__SET &&
       xmlnode_get_tag(jp->x,"query/remove")!=NULL)
      {
      // test if submit or cancel
      jtin->Stats->CoreAccounts--;
      jtin->Stats->_CoreAccounts--;
      smtp_StatsSave();
      lcJID=smtp_GetJID(par->tmppool,xmlnode_get_attrib(jp->x,"from"));

      SMTP_DropItemRoster(lcJID);

      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1310, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");
      liProcess=1;
      }

   
   // register service - proccess data (submit)
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__SET &&
       (xData=xmlnode_get_tag(jp->x,"query/x?type=submit"))!=NULL)
      {
      // test if submit or cancel

      lcJID=smtp_GetJID(par->tmppool,xmlnode_get_attrib(jp->x,"from"));
      loJID=SMTP_GetItemRoster(lcJID,1);
      liDefault=j_atoi(xmlnode_get_attrib(loJID,"default"),0);

      smtp_opiqr_SaveToJID(xData,loJID);
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);

      if (liDefault==1) // user was not registered
         {
         jtin->Stats->CoreAccounts++;
         jtin->Stats->_CoreAccounts++;
         smtp_StatsSave();

         smtp_AppendQueueItem(loQueue, loNextQ=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X));
         loData=(smtp_jq_x) loNextQ->Data;
         loData->x=out_SetReply(xmlnode_new_tag("presence"),jp->x);
         PM_Reg(1320,NULL, xmlnode_pool(loData->x),1,NULL);

         xmlnode_put_attrib(loData->x,"type","subscribe");

         smtp_AppendQueueItem(loQueue, loNextQ=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_CB));
         loDataCB=(smtp_jq_cb) loNextQ->Data;
         loDataCB->cb=(void*) smtp_paid_daemon;
         loDataCB->arg=(void*) jtin;
         #ifdef SMTP_DB
          SMTP_DEBUG(SMTP_ZONE,"Call calback procedure %i, %i",loDataCB->cb,loDataCB->arg);
         #endif

         if (j_strlen(par->lang)>0)
            par->lang[2]='\0';
         xmlnode_put_attrib(loJID,"lang",par->lang);

         SMTP_SetItemRoster(loJID,1);
         }

     
      xmlnode_free(loJID);

      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1330, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_REGISTER);

	  liProcess=1;
      }

   // register service - proccess data (cancel)
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__SET &&
       (xData=xmlnode_get_tag(jp->x,"query/x?type=cancel"))!=NULL)
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1340,NULL, xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_REGISTER);
	  liProcess=1;
      }

   if (liProcess==1)
      smtp_FlushQueue(par->i, loQueue);

   return liProcess;
   }

