#include "smtp.h"
extern smtpi jtin;

void smtp_stats_out(xmlnode x)
   {
   jpacket jp;
   pool p=pool_new();
   PM_Reg(1440, NULL,p,1,NULL);

   jp=(jpacket) pmalloc(p,sizeof(_jpacket));
   jp->x=x;
   jpacket_reset(jp);
   jpacket_subtype(jp);

   jtin->Stats->_XMPPOutAll+=1;
   jtin->Stats->XMPPOutAll+=1;
   switch(jp->type)
      {
      // is it message?
      case JPACKET_MESSAGE:
           jtin->Stats->_XMPPOutMessage+=1;
           jtin->Stats->XMPPOutMessage+=1;
           break;

      // is it presence?
      case JPACKET_PRESENCE:
           jtin->Stats->_XMPPOutPresence+=1;
           jtin->Stats->XMPPOutPresence+=1;
           break;

      // is it presence(x)?
      case JPACKET_S10N:
           jtin->Stats->_XMPPOutSN10+=1;
           jtin->Stats->XMPPOutSN10+=1;
           break;

      // is it iq?
      case JPACKET_IQ:
           jtin->Stats->_XMPPOutIQ+=1;
           jtin->Stats->XMPPOutIQ+=1;
           break;

      // is it unknown packet?
      case JPACKET_UNKNOWN:
           jtin->Stats->_XMPPOutUnknown+=1;
           jtin->Stats->XMPPOutUnknown+=1;
           break;
      }
   smtp_StatsSave();
   pool_free(p);
   }

void smtp_stats_in(xmlnode x)
   {
   jpacket jp;
   pool p=pool_new();
   PM_Reg(1450, NULL,p,1,NULL);

   jp=(jpacket) pmalloc(p,sizeof(_jpacket));
   jp->x=x;
   jpacket_reset(jp);
   jpacket_subtype(jp);

   jtin->Stats->_XMPPInAll+=1;
   jtin->Stats->XMPPInAll+=1;
   switch(jp->type)
      {
      // is it message?
      case JPACKET_MESSAGE:
           jtin->Stats->_XMPPInMessage+=1;
           jtin->Stats->XMPPInMessage+=1;
           break;

      // is it presence?
      case JPACKET_PRESENCE:
           jtin->Stats->_XMPPInPresence+=1;
           jtin->Stats->XMPPInPresence+=1;
           break;

      // is it presence(x)?
      case JPACKET_S10N:
           jtin->Stats->_XMPPInSN10+=1;
           jtin->Stats->XMPPInSN10+=1;
           break;

      // is it iq?
      case JPACKET_IQ:
           jtin->Stats->_XMPPInIQ+=1;
           jtin->Stats->XMPPInIQ+=1;
           break;

      // is it unknown packet?
      case JPACKET_UNKNOWN:
           jtin->Stats->_XMPPInUnknown+=1;
           jtin->Stats->XMPPInUnknown+=1;
           break;
      }
   smtp_StatsSave();
   pool_free(p);
   }

// do pamtovch statistik pidat i poty item

void smtp_statistics_write(xmlnode loQuery,const char *lcTagName, const char *lcUnitName, const char *lcValue)
   {
   xmlnode loStatN;
   xmlnode_put_attrib(loStatN=xmlnode_insert_tag(loQuery,"stat"),"name",lcTagName);
   xmlnode_put_attrib(loStatN,"units",lcUnitName);
   xmlnode_put_attrib(loStatN,"value",lcValue); 
   }

int smtp_out_packets_iq_stats(smtpp par, char *type)
   {
   int liProcess=0,lii,liPom,liAdmin;
   jpacket jp=par->jp;
   char *lcPom,*lcName,*lcNode,*lcJID,*lcNodeX;
   pool p=par->tmppool;
   xmlnode loQuery, loStat;
   smtp_jq loQueue;
   smtp_jq_x loData;
   smtp_rjids loGroup=jtin->roster;
   smtp_rjid  loItemR;
   smtp_cjid  loItemCL=jtin->ContactList;
   smtp_jcmdq loQCmd=jtin->qcmd;
   PMI_struc loPoolI=jtin->pools;

   lcNode=xmlnode_get_attrib(jp->iq,"node");
   loStat=xmlnode_get_firstchild(jp->iq);

   liPom=27;
   lcPom = (char*)pmalloc_x(par->tmppool, liPom+1,' ');
   lcPom[liPom] = '\0';

   lcJID=smtp_GetJID(par->tmppool,jid_full(jp->from));
   liAdmin=_smtp_opm_check_JID(lcJID,SMTP_ADMIN_NS_TRANSPORT);


   // stats for transport-NODE, define
   if (liProcess==0 && j_strcmp(jp->iqns,NS_STATS)==0 &&
       jp->subtype==JPACKET__GET && jp->to->user==NULL && 
       j_strlen(lcNode)>0 &&
       strncmp(lcNode,"adminreports/memory",19)==0 && loStat==NULL && liAdmin==1
      )
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1400,NULL, xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_STATS);
      xmlnode_put_attrib(loQuery,"node",lcNode);

      // memory branch
      if (j_strcmp(lcNode,"adminreports/memory")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","transport");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","poolmanagercore");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","poolmanagerdata");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","all");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","accounts");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","configruntime");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","resources");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/commands");
         }

      // Account section
      if (j_strcmp(lcNode,"adminreports/memory/accounts")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","all");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","data");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","core");
         }

      if (j_strcmp(lcNode,"adminreports/memory/accounts/core")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","core");
         }

      if (j_strcmp(lcNode,"adminreports/memory/accounts/data")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","data");
         while(loGroup != NULL)
              {
              loItemR=loGroup->item;

              while(loItemR != NULL)
                   {
                   xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",loItemR->cJID);
                   if (loItemR->next != NULL)
                      loItemR = loItemR->next;
                   else
                      break;
                   }

              if (loGroup->next != NULL)
                 loGroup = loGroup->next;
              else
                 break;
              }
         }

      if (strncmp(lcNode,"adminreports/memory/accounts/data/",34)==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",lcNode+34);
         }

      // Contacts section
      if (j_strcmp(lcNode,"adminreports/memory/contacts")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","all");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","data");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","core");
         }

      if (j_strcmp(lcNode,"adminreports/memory/contacts/core")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","core");
         }

      if (j_strcmp(lcNode,"adminreports/memory/contacts/data")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","data");
         while(loItemCL != NULL)
              {
              xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",loItemCL->cJID);

              if (loItemCL->next != NULL)
                 loItemCL = loItemCL->next;
              else
                 break;
              }
         }

      if (strncmp(lcNode,"adminreports/memory/contacts/data/",34)==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",lcNode+34);
         }


      // jabber section
      if (j_strcmp(lcNode,"adminreports/memory/jabber")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","all");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","messages");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","commands");
         }

      if (j_strcmp(lcNode,"adminreports/memory/jabber/commands")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","all");
         while(loQCmd != NULL)
              {
              xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",loQCmd->cSessionID);

              if (loQCmd->next != NULL)
                  loQCmd = loQCmd->next;
              else
                  break;
              }
         }

      if (strncmp(lcNode,"adminreports/memory/jabber/commands/",36)==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",lcNode+36);
         }

      if (j_strcmp(lcNode,"adminreports/memory/jabber/messages")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","all");
         while(loPoolI != NULL)
              {
              if (loPoolI->index==7000)
                 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",smtp_itoa(p,(int) loPoolI->pl));

              if (loPoolI->next != NULL)
                 loPoolI = loPoolI->next;
              else
                 break;
              }
         }

      if (strncmp(lcNode,"adminreports/memory/jabber/messages/",36)==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",lcNode+36);
         }


      // smtp section
      if (j_strcmp(lcNode,"adminreports/memory/smtp")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","all");
         while(loPoolI != NULL)
              {
              if (loPoolI->index==7000)
                 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",smtp_itoa(p,(int) loPoolI->pl));

              if (loPoolI->next != NULL)
                 loPoolI = loPoolI->next;
              else
                 break;
              }
         }

      if (strncmp(lcNode,"adminreports/memory/smtp/",25)==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name",lcNode+25);
         }

      if (j_strcmp(lcNode,"adminreports/memory/contacts/resources")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","resources");
         }

      if (j_strcmp(lcNode,"adminreports/memory/contacts/configruntime")==0)
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","configruntime");
         }

      
      liProcess=1;
      }


   // stats for transport-NODE, values
   if (liProcess==0 && j_strcmp(jp->iqns,NS_STATS)==0 &&
       jp->subtype==JPACKET__GET && jp->to->user==NULL && 
       j_strlen(lcNode)>0 &&
       strncmp(lcNode,"adminreports/memory",19)==0 && loStat!=NULL && liAdmin==1
      )
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1410,NULL, xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_STATS);
      xmlnode_put_attrib(loQuery,"node",lcNode);

      // read all childs elements
      for (;loStat != NULL; loStat = xmlnode_get_nextsibling(loStat))
          {
          if (loStat->type!=NTYPE_TAG)
  	          continue;

          // main section
          lcName=xmlnode_get_attrib(loStat,"name");
          lcNodeX=spools(p,lcNode,"/",lcName,p);

          if (j_strcmp(lcNodeX,"adminreports/memory/all")==0)
             {
             snprintf(lcPom, liPom, "%i\0",pool_size(jtin->i->p)+PM_GetMem(0,(pool) NULL,SMTP_MEMORY_ALL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/transport")==0)
             {
             snprintf(lcPom, liPom, "%i\0",pool_size(jtin->i->p));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/poolmanagercore")==0)
             {
             lii=PM_GetMem(0,NULL,SMTP_MEMORY_CORE);
             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/poolmanagerdata")==0)
             {
             lii=PM_GetMem(0,NULL,SMTP_MEMORY_DATA);
             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);

/*
             next=jtin->pools;
             while(next != NULL)
                {
                snprintf(lcPom, liPom, "%i\0",pool_size(next->pl));
//                smtp_statistics_write(loQuery,spools(par->tmppool,"poolmanagerdata-",smtp_itoa(par->tmppool,next->index),"-",smtp_pttoa(par->tmppool,(void*)next->pl)," (",next->cJID,")",par->tmppool), "bytes",lcPom);
                smtp_statistics_write(loQuery,spools(par->tmppool,"poolmanagerdata-",smtp_itoa(par->tmppool,next->index),"-",smtp_pttoa(par->tmppool,(void*)next->pl),par->tmppool), "bytes",lcPom);

                if (next->next != NULL)
                   next = next->next;
                else
                   break;
                }
*/

   	         continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/accounts")==0)
             {
             lii=SMTP_GetItemMemRoster(SMTP_MEMORY_ALL,NULL);

             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/contacts")==0)
             {
             lii=SMTP_GetItemMemCL(SMTP_MEMORY_ALL,NULL);

             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }


          if (j_strcmp(lcNodeX,"adminreports/memory/jabber/all")==0)
             {
             lii=PM_GetMem(7000,(pool) NULL,SMTP_MEMORY_ALL)+smtp_CmdGetMem(SMTP_MEMORY_ALL,NULL);

             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/jabber/commands")==0 ||
              j_strcmp(lcNodeX,"adminreports/memory/jabber/commands/all")==0 
             )
             {
             lii=smtp_CmdGetMem(SMTP_MEMORY_ALL,NULL);

             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/jabber/messages")==0 ||
              j_strcmp(lcNodeX,"adminreports/memory/jabber/messages/all")==0
             )
             {
             snprintf(lcPom, liPom, "%i\0",PM_GetMem(7000,(pool) NULL,SMTP_MEMORY_ALL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }

          if (strncmp(lcNode,"adminreports/memory/jabber/messages",35)==0)
             {
             snprintf(lcPom, liPom, "%i\0",PM_GetMem(7000,(pool) NULL,SMTP_MEMORY_ALL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }

          if (strncmp(lcNode,"adminreports/memory/jabber/messages",35)==0 && j_strcmp(lcName,"all")!=0)
             {
             snprintf(lcPom, liPom, "%i\0",PM_GetMem(7000,(pool) j_atoi(lcName,0),SMTP_MEMORY_ALL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }


          if (j_strcmp(lcNodeX,"adminreports/memory/smtp/all")==0)
             {
             snprintf(lcPom, liPom, "%i\0",PM_GetMem(5000,(pool) NULL,SMTP_MEMORY_ALL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }

          if (strncmp(lcNode,"adminreports/memory/smtp",24)==0 && j_strcmp(lcName,"all")!=0)
             {
             snprintf(lcPom, liPom, "%i\0",PM_GetMem(5000,(pool) j_atoi(lcName,0),SMTP_MEMORY_ALL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }


          if (j_strcmp(lcNodeX,"adminreports/memory/accounts/all")==0)
             {
             snprintf(lcPom, liPom, "%i\0",SMTP_GetItemMemRoster(SMTP_MEMORY_ALL,NULL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/accounts/data")==0)
             {
             snprintf(lcPom, liPom, "%i\0",SMTP_GetItemMemRoster(SMTP_MEMORY_DATA,NULL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/accounts/core")==0)
             {
             snprintf(lcPom, liPom, "%i\0",SMTP_GetItemMemRoster(SMTP_MEMORY_CORE,NULL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }

          if ((strncmp(lcNode,"adminreports/memory/accounts/data",33)==0 && strchr(lcName,'@')>0))
             {
             snprintf(lcPom, liPom, "%i\0",SMTP_GetItemMemRoster(SMTP_MEMORY_JID,lcName));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }


          if (j_strcmp(lcNodeX,"adminreports/memory/contacts/all")==0)
             {
             snprintf(lcPom, liPom, "%i\0",SMTP_GetItemMemCL(SMTP_MEMORY_ALL,NULL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/contacts/data")==0)
             {
             snprintf(lcPom, liPom, "%i\0",SMTP_GetItemMemCL(SMTP_MEMORY_DATA,NULL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/contacts/core")==0)
             {
             snprintf(lcPom, liPom, "%i\0",SMTP_GetItemMemCL(SMTP_MEMORY_CORE,NULL));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }

          if (strncmp(lcNode,"adminreports/memory/contacts/data",33)==0 && strchr(lcName,'@')>0
             )
             {
             snprintf(lcPom, liPom, "%i\0",SMTP_GetItemMemCL(SMTP_MEMORY_JID,lcName));
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }


          if (j_strcmp(lcNodeX,"adminreports/memory/configruntime")==0)
             {
             lii=PM_GetMem(3030,(pool) NULL,SMTP_MEMORY_ALL);

             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }

          if (j_strcmp(lcNodeX,"adminreports/memory/resources")==0)
             {
             lii=PM_GetMem(3040,(pool) NULL,SMTP_MEMORY_ALL);

             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
 		     continue;
             }


          }
      liProcess=1;
      }



//**************************************************

   // stats for transport, define
   if (liProcess==0 && j_strcmp(jp->iqns,NS_STATS)==0 &&
       jp->subtype==JPACKET__GET && jp->to->user==NULL && 
       j_strlen(lcNode)==0 && loStat==NULL
      )
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1420, NULL,xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_STATS);

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","start");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","start/lastdatetime");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","memory");

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","users");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","users/paid");

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts");

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","accounts");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","accounts/elapsed");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","accounts/paid");


      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/messages");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/messages/out");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/messages/out/error");

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/elapsed/messages");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/elapsed/messages/out");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/elapsed/messages/out/error");

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/command/unknown");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/command/unknown");

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/messages");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/processed");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/notregisteredrecipient");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/badrecipient");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/blockedbyrecipient");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/spam");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/maxsize");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/noprocess");

	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/bouncy");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/norecipient");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/spammers");

      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/messages");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/processed");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/notregisteredrecipient");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/badrecipient");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/blockedbyrecipient");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/spam");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/maxsize");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/noprocess");

	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/bouncy");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/norecipient");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/spammers");


	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/all");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/message");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/presence");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/sn10");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/iq");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/unknown");

	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/elapsed/all");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/elapsed/message");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/elapsed/presence");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/elapsed/sn10");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/elapsed/iq");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/in/elapsed/unknown");

	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/all");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/message");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/presence");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/sn10");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/iq");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/unknown");

	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/elapsed/all");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/elapsed/message");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/elapsed/presence");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/elapsed/sn10");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/elapsed/iq");
	  xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","xmpp/out/elapsed/unknown");

      liProcess=1;
      }

   // stats for transport, values
   if (liProcess==0 && j_strcmp(jp->iqns,NS_STATS)==0 &&
       jp->subtype==JPACKET__GET && jp->to->user==NULL && 
       j_strlen(lcNode)==0 && loStat!=NULL
      )
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      PM_Reg(1430,NULL, xmlnode_pool(loData->x),1,NULL);

      xmlnode_put_attrib(loData->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_STATS);

      // read all childs elements
      for (;loStat != NULL; loStat = xmlnode_get_nextsibling(loStat))
          {
          if (loStat->type!=NTYPE_TAG)
  	          continue;

          // main section
          lcName=xmlnode_get_attrib(loStat,"name");
          if (j_strcmp(lcName,"start")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->Start);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
		     continue;
             }

          if (j_strcmp(lcName,"start/lastdatetime")==0)
             {
             smtp_statistics_write(loQuery,lcName, "date",jtin->Stats->StartLastDatetime);
		     continue;
             }


          if (j_strcmp(lcName,"memory")==0)
             {
             // smtp_rjidGetMem() pamt online rosteru
             // smtp_CmdGetMem() pamt pkazov fronty
             // pool_size(jtin->resources->p) pamt zabrajc zdroje
             // 
             //if (jtin->roster->p!=jtin->i->p)
             //   lii+=pool_size(jtin->roster->p);

             lii=pool_size(jtin->i->p)+PM_GetMem(0,(pool) NULL,SMTP_MEMORY_ALL);
             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "bytes",lcPom);
		     continue;
             }

          // poet uivatel dle uloench kontaktlist
          if (j_strcmp(lcName,"users")==0)
             {
             snprintf(lcPom, liPom, "%i\0",smtp_cjidGetCount(0));
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          // poet uivatel, kte maj zaplaceno VIP 
          if (j_strcmp(lcName,"users/paid")==0)
             {
             snprintf(lcPom, liPom, "%i\0",smtp_cjidGetCount(1));
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }
 
          // celkov poet kontakt
          if (j_strcmp(lcName,"contacts")==0)
             {
             snprintf(lcPom, liPom, "%i\0",smtp_cjidGetContactsCount());
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }


          // celkov poet t
          if (j_strcmp(lcName,"accounts")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_CoreAccounts);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          // poet novch t od poslednho pihlen
          if (j_strcmp(lcName,"accounts/elapsed")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->CoreAccounts);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          // poet t s VIP
          if (j_strcmp(lcName,"accounts/paid")==0)
             {
             lii=SMTP_GetItemCountRoster(SMTP_ACCOUNT_PAID);
             snprintf(lcPom, liPom, "%i\0",lii);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }


          // jabber side
          if (j_strcmp(lcName,"jabber/messages")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_JabberMessages);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"jabber/messages/out")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_JabberMessagesOut);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"jabber/messages/out/error")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_JabberMessagesOutError);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"jabber/elapsed/messages")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->JabberMessages);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"jabber/elapsed/messages/out")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->JabberMessagesOut);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }


          if (j_strcmp(lcName,"jabber/elapsed/messages/out/error")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->JabberMessagesOutError);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/command/unknown")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPCommandUnknown);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/command/unknown")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPCommandUnknown);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/messages")==0)
             {
             snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->Stats->_SMTPMessages);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }


          if (j_strcmp(lcName,"smtp/processed")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPProcessed);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/notregisteredrecipient")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPNRRecipient);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/badrecipient")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPBadRecipient);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/messages")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPMessages);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/processed")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPProcessed);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/notregisteredrecipient")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPNRRecipient);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/badrecipient")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPBadRecipient);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/spam")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPSpam);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/spam")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPSpam);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/maxsize")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPMaxSize);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/maxsize")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPMaxSize);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/noprocess")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPNoProcess);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/noprocess")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPNoProcess);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }


          if (j_strcmp(lcName,"smtp/bouncy")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPBouncy);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/norecipient")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPNoRecipient);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }


          if (j_strcmp(lcName,"smtp/elapsed/bouncy")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPBouncy);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/norecipient")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPNoRecipient);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/elapsed/spammers")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPSpammers);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/spammers")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPSpammers);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }


          if (j_strcmp(lcName,"smtp/elapsed/blockedbyrecipient")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->SMTPBlockedByRecipient);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"smtp/blockedbyrecipient")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_SMTPBlockedByRecipient);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/all")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPInAll);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/message")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPInMessage);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/presence")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPInPresence);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/sn10")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPInSN10);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/iq")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPInIQ);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/unknown")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPInUnknown);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }


          if (j_strcmp(lcName,"xmpp/in/elapsed/all")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPInAll);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/elapsed/message")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPInMessage);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/elapsed/presence")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPInPresence);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/elapsed/sn10")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPInSN10);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/elapsed/iq")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPInIQ);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/in/elapsed/unknown")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPInUnknown);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/all")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPOutAll);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/message")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPOutMessage);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/presence")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPOutPresence);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/sn10")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPOutSN10);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/iq")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPOutIQ);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/unknown")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->_XMPPOutUnknown);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }


          if (j_strcmp(lcName,"xmpp/out/elapsed/all")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPOutAll);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/elapsed/message")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPOutMessage);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/elapsed/presence")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPOutPresence);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/elapsed/sn10")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPOutSN10);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/elapsed/iq")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPOutIQ);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

          if (j_strcmp(lcName,"xmpp/out/elapsed/unknown")==0)
             {
             snprintf(lcPom, liPom, "%i\0",jtin->Stats->XMPPOutUnknown);
             smtp_statistics_write(loQuery,lcName, "count",lcPom);
             continue;
             }

         }

      liProcess=1;
      }


   if (liProcess==1)
      smtp_FlushQueue(par->i, loQueue);


   return liProcess;
   }
