#include "smtp.h"

/* jabber->smtp */

extern smtpi jtin;


/* send an outgoing line to the connection */
void smtp_cmd(smtps so, int liCmd, char *arg)
   {
   char *lcOut;
   pool p;
   spool lspLine;

   p = pool_new();
   PM_Reg(7010,so->p, p,1,NULL);

   lspLine = spool_new(p);

   switch(liCmd)
      {
      case CMD_HELO:
           spool_add(lspLine,"HELO ");
           break;

      case CMD_EHLO:
           spool_add(lspLine,"EHLO ");
           break;

      case CMD_MAIL:
           spool_add(lspLine,"MAIL FROM: ");
           break;

      case CMD_RCPT:
           spool_add(lspLine,"RCPT TO: ");
           break;

      case CMD_DATA:
           spool_add(lspLine,"DATA");
           break;

      case CMD_QUIT:
           spool_add(lspLine,"QUIT");
           break;
      }

   if (arg != NULL)
      {
      if (liCmd == CMD_HELO || liCmd == CMD_EHLO)
         spool_add(lspLine,arg);
      else
         spooler(lspLine,"<",arg,">",lspLine);
      }

   spool_add(lspLine,"\r\n");
   lcOut = spool_print(lspLine);
   so->lastcmd = liCmd;
   so->cLastOut = pstrdup(so->p,lcOut);
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"SMTP-SEND %s",lcOut);
   #endif

   mio_write(so->m,NULL,lcOut,-1);

   pool_free(p);
   }

/* decode the incoming commands */
void smtp_out_status(smtps so,char *lcData)
   {
   char *lineEnd, *lcBody,*lcBFile, *lcSubj, *lcPom,*lcXXX;
   xmlnode x,xError,loSubj,loText;
   jid cur;
   int liStatus=so->iStatus,liSaved=0,liLen,liAtt=0,liProcess=1;
   pool p;
   spool loXXX;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"status %d response to command %d with data %s",liStatus,so->lastcmd,lcData);
   #endif

   switch(so->lastcmd)
      {

      case CMD_NONE:
           if (liStatus != SMTP_CODE_220)
              break;
 
           smtp_cmd(so, CMD_HELO, jtin->me);
           return;

      case CMD_HELO:
           if (liStatus != SMTP_CODE_250)
              break;

           smtp_cmd(so, CMD_MAIL, so->from);
           return;

      case CMD_EHLO:
           if (liStatus != SMTP_CODE_250)
              break;

           smtp_cmd(so, CMD_MAIL, so->from);
           return;


      case CMD_MAIL:
           if (liStatus != SMTP_CODE_250)
              break;

           for (cur = so->rcpt; cur != NULL; cur = cur->next)
               smtp_cmd(so, CMD_RCPT, jid_full(cur));

           return;

      case CMD_RCPT:
           so->ircpt--;

           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_251))
              break;

           if (so->ircpt==0)
              smtp_cmd(so, CMD_DATA, NULL);

           return;

      case CMD_RCPTE:
           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_251))
              break;

           smtp_cmd(so, CMD_DATA, NULL);
           return;

      case CMD_DATA:
           lcBody = xmlnode_get_data_pool(so->p,so->x);

           if (liStatus != SMTP_CODE_354)
              break;

           for (x = xmlnode_get_firstattrib(so->x); x != NULL; x = xmlnode_get_nextsibling(x))
               {
               liAtt=1;
               mio_write(so->m,NULL,xmlnode_get_name(x),-1);
               mio_write(so->m,NULL,": ",2);
               mio_write(so->m,NULL,xmlnode_get_data(x),-1);
               mio_write(so->m,NULL,"\r\n",2);
               }

           xmlnode_free(so->x);
           so->x=NULL;

           if (liAtt==1)
              mio_write(so->m,NULL,"\r\n",2);

           if (lcBody == NULL)
              {
              so->lastcmd = CMD_DATAEND; /* so we know where we are */
              mio_write(so->m,NULL,"\r\n.\r\n",5);
              return;
              }

           while((lineEnd = strchr(lcBody,'\n')) != NULL)
      	      {
       		  lineEnd[0] = '\0';	/* cut the line */
              lineEnd--;
              if (*lineEnd=='\r' || *lineEnd=='\n')
       		      *lineEnd = '\0';	/* cut the line */

             // S:2005-04-03 gorila@dione.zcu.cz
//		     while((crpointer = strchr(body, '\r')) != NULL)
//             crpointer[0] = ' ';
             // E:2005-04-03 gorila@dione.zcu.cz
 
 		      if (lcBody[0]=='.')
                 {
		         mio_write(so->m,NULL,".",1); /* escape the dot */
		         mio_write(so->m,NULL,lcBody,-1); /* escape the dot */
		         mio_write(so->m,NULL,"\r\n",2); /* escape the dot */
                 }
              else
                 {
                 // S:2005-04-03 gorila@dione.zcu.cz
                 // xmlnode2str() return original XML data (without any changes)
                 // xmlnode_get_tag_data() return data where CRLF and CR are replaced by LF
                 // _mio_write_dump() hate data with length = 0
                 // I added this exception
	             if (j_strlen(lcBody)>0)
                    {
                    mio_write(so->m,NULL,lcBody,-1);
                    mio_write(so->m,NULL,"\r\n",2);
                    }
                 // E:2005-04-03 gorila@dione.zcu.cz
                 else 
		            mio_write(so->m,NULL,"\r\n",2);
                 }

		      lcBody = lineEnd+2;	/* point to next line */
	          }


	       if (j_strlen(lcBody)>0)
		      mio_write(so->m,NULL,lcBody,-1); /* print the rest */

           so->lastcmd = CMD_DATAEND; /* so we know where we are */

           mio_write(so->m,NULL,"\r\n.\r\n",5);
           return;

      case CMD_DATAEND:
           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_221))
              break;

           jtin->Stats->JabberMessagesOut++;
           jtin->Stats->_JabberMessagesOut++;
           smtp_StatsSave();

           smtp_cmd(so, CMD_QUIT, NULL);


		   // Odeslan prezence o odesln mailu
           if (so->jp!=NULL && j_strcmp(jid_full(so->jp->from),jtin->met)!=0)
              {
              p=pool_new();
              PM_Reg(7020,so->p, p,1,NULL);
              lcXXX=spools(p,smtp_rc_GetString(so->p,so->lang,SMTP_XXX_MESSAGE_SENT),"\r\n",xmlnode_get_data(xmlnode_get_tag(so->jp->x,"body")),p);
              smtp_SendInfoToAny(NULL,jid_full(so->jp->from), lcXXX ,j_atoi(xmlnode_get_attrib(so->oJID,"SendSystemMessage"),SMTP_SITA_P),NULL);
              pool_free(p);
              }
		   return;

      case CMD_QUIT:
           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_221))
              break;

           return;

      default:
            log_warn("smtp","SMTP relay connection not processed %d %d: %s",so->lastcmd,liStatus,lcData);
            smtp_SendInfoToAdmin(spools(so->p,"SMTP relay connection not processed ",smtp_itoa(so->p,so->lastcmd)," ",so->cLastOut," ",smtp_itoa(so->p,liStatus)," ",lcData,so->p),SMTP_SITA_P );
            liProcess=0;
      }

   #ifdef SMTP_DB
    log_warn("smtp","SMTP relay connection failed %d %s %d %s",so->lastcmd,so->cLastOut,liStatus,lcData);
   #endif

   if (liProcess==1) // pokud dolo ke zpracovn a byla tam chyba
      smtp_SendInfoToAdmin(spools(so->p,"SMTP relay process failed ",smtp_itoa(so->p,so->lastcmd)," ",so->cLastOut," ",smtp_itoa(so->p,liStatus)," ",lcData,so->p),SMTP_SITA_M);

   jtin->Stats->JabberMessagesOutError++;
   jtin->Stats->_JabberMessagesOutError++;
   smtp_StatsSave();


   if ((so->lastcmd==CMD_RCPT || so->lastcmd==CMD_RCPTE) && so->jp!=NULL)
      {
      // unknown recipient - must be message
      if (j_strcmp(jid_full(so->jp->from),jtin->met)!=0)
         {

         p=pool_new();
         PM_Reg(7021,so->p, p,1,NULL);
         loXXX=spool_new(p);

         xmlnode_put_attrib(xError=xmlnode_new_tag("error"),"code","404");
         xmlnode_put_attrib(xError,"type","wait");
         xmlnode_put_attrib(xmlnode_insert_tag(xError,"recipient-unavailable"),"xmlns","urn:ietf:params:xml:ns:xmpp-stanzas");
         xmlnode_put_attrib(loText=xmlnode_insert_tag(xError,"text"),"xmlns","urn:ietf:params:xml:ns:xmpp-stanzas");
         xmlnode_insert_cdata(loText,lcData,-1);

         if ((loSubj=xmlnode_get_tag(so->jp->x,"subject"))!=NULL)
            {
            lcSubj=xmlnode_get_data(loSubj);
            }
         liLen=j_strlen(lcSubj)>0;

         lcPom=smtp_rc_GetString(so->p,so->lang,SMTP_XXX_RCPT_NOTFOUND);
         if (liLen==0 || strstr(lcSubj,lcPom)==NULL)
            {
            spooler(loXXX,lcPom,loXXX);
            if (liLen>0)
               spooler(loXXX,"  ",loXXX);
            }

         if (liLen>0)
            spooler(loXXX,lcSubj,loXXX);

         smtp_SendInfoToAny(NULL,jid_full(so->jp->from), spool_print(loXXX) ,j_atoi(xmlnode_get_attrib(so->oJID,"SendSystemMessage"),SMTP_SITA_P),xError);
         pool_free(p);
         }
     }
   else
      {

      // save message to offline folder
      if (jtin->tmpOfflineJabber==1 && so->jp!=NULL)
         {
         lcBFile=spools(so->p, tempnam(jtin->jabber_offline, "tmp"),".xml",so->p);
         if ((liSaved=xmlnode2file(lcBFile  ,so->jp->x))!=1)
            {
            smtp_SendInfoToAdmin(spools(so->p,"Save message to offline repository ",lcBFile," failed.",so->p),SMTP_SITA_P );
            log_warn("smtp","Cannot save message to %s",lcBFile);
            }
         }

      if (liSaved==1)
         lcPom=smtp_rc_GetString(so->p,so->lang,SMTP_XXX_SMTP_UNKNOWN_1);
      else
         lcPom=smtp_rc_GetString(so->p,so->lang,SMTP_XXX_SMTP_UNKNOWN_0);

      smtp_SendInfoToAdmin(lcPom,SMTP_SITA_M );

      if (so->jp!=NULL && j_strcmp(jid_full(so->jp->from),jtin->met)!=0)
         {
         // other errors - can be presence
         p=pool_new();
         PM_Reg(7030,so->p, p,1,NULL);
         lcXXX=spools(p,lcPom,"\r\n",xmlnode_get_data(xmlnode_get_tag(so->jp->x,"body")),p);
         xmlnode_put_attrib(xError=xmlnode_new_tag("error"),"code",smtp_itoa(xmlnode_pool(x),liStatus));
         xmlnode_put_attrib(xError,"type","wait");
         xmlnode_put_attrib(xmlnode_insert_tag(xError,"x-domain-name-required-for-sender-address"),"xmlns","urn:ietf:params:xml:ns:xmpp-stanzas");
         xmlnode_put_attrib(loText=xmlnode_insert_tag(xError,"text"),"xmlns","urn:ietf:params:xml:ns:xmpp-stanzas");
         smtp_SendInfoToAny(NULL,jid_full(so->jp->from), lcXXX ,j_atoi(xmlnode_get_attrib(so->oJID,"SendSystemMessage"),SMTP_SITA_P),xError);
         pool_free(p);
         }
      }


   // if this error, end session with SMTP server
   if (so->lastcmd != CMD_QUIT)
      smtp_cmd(so, CMD_QUIT, NULL);
   }

/* when the connection dies, clean up the mess */
void smtp_out_cleanup(void *arg)
   {
   smtps so = (smtps)(arg);

   if (so != NULL)
      {
      if (so->oJID!=NULL)
          xmlnode_free(so->oJID);

      so->oJID=so->oAD=NULL;
      free(so->buffer);
      so->buffer=NULL;

      if (so->x!=NULL)
         {
         xmlnode_free(so->x);
         so->x=NULL;
         }
      }
   }


void smtp_out_add_recipient_to_lis(spool list, char *lcOrig, char *lcRCPT, char *lcLabel, int *liCount)
   {
   int liOrig=j_strlen(lcOrig),liLabel=j_strlen(lcLabel);

   if (*liCount==0 && liLabel==liOrig)
      spooler(list,"<",lcRCPT,">",list);

   if (*liCount==0 && liLabel>liOrig)
      spooler(list,"\"=?utf-8?q?",lcLabel,"?=\" ","<",lcRCPT,">",list);

   if (*liCount>0 && liLabel==liOrig)
      spooler(list,"\r\n ,","<",lcRCPT,">",list);

   if (*liCount>0 && liLabel>liOrig)
      spooler(list,"\r\n ,\"=?utf-8?q?",lcLabel,"?=\" ","<",lcRCPT,">",list);

   *liCount=*liCount+1;
   }


smtps smtp_out_new(smtps so, void *lugmArg)
   {
   jid ljidFrom;
   char *to, *host, *subject, *id, *tocc, *lcCB, *tmp, *lcJID, *lcRTName, *lcRTAddr, *lcFrom,*lcPom,*smtpCT,
        *dateheader, *smtpboundary, *lcFRName, *lcFRAddr;
   time_t now_unixtime;
   struct tm now;
   jpacket jp=so->jp;
   xmlnode html,meta,thread,tagx,tagxchild, loHTML=NULL, loBody=NULL, loEncrypted=NULL,loCB=NULL,loSubj=NULL, loSigned=NULL,loItem;
   spool datato,datacc,databcc;
   int liLen,liPGP=0,liMode,lidatato=0,lidatacc=0,lidatabcc=0,lii;
   pool tmpp;

   /* translate the jabber address to a sutiable SMTP sender */
   if (j_strcmp(jid_full(jp->from),jtin->met)==0)
      ljidFrom = jid_new(so->p, spools(so->p,"MAILER-DAEMON","@",jtin->me,so->p));
   else
      ljidFrom = smtp_2mx(jp->from);

   /* translate the recipient into a SMTP address */
   to = pstrdup(jp->p,jp->to->user);
   host = strstr(to,"%");
   *host = '@';
   ++host;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"yay, sending a message from %s to %s",jid_full(ljidFrom),to);
   #endif

   dateheader =(char*)pmalloc_x(so->p, 28,' ');
   dateheader[27]='\0';
   smtpboundary=(char*)pmalloc_x(so->p, 31,' ');
   smtpboundary[30]='\0';


   lcFrom=jid_full(ljidFrom);
   PM_Reg(7080,so->p, tmpp=pool_new(),1,NULL);
   tmp = (char*)pmalloco(tmpp, EQP_LENGTH(j_strlen(lcFrom)));
   toEscape(lcFrom, (void *) tmp,SEQ_ESCAPE);
   lcFrom=so->from=pstrdup(so->p,tmp);
   pool_free(tmpp);


   datato = spool_new(so->p);
   datacc = spool_new(so->p);
   databcc = spool_new(so->p);

   // projed vsechny pijemce
   // do 1. seznamu dej vechny (vetn to/cc/bcc) co pouvaj nastaven tu/globln
   // do 2. seznamu dej vechny (vetn to/cc/bcc) co pouvaj vlastn nastaven a ke kadmu nati vlastn nastaven
   //SMTP_PieceSettings(char *lcFrom , char *lcTo, int *liType)
   // jednosmrn seznam (struc, ->next) jid, oJID (settings), type (to/cc/bcc)

   // vygeneruj seznamy to, cc a bcc, pouij se pozdji

   // pro 1. seznam spust generovn emailu, kadho pjemce pidej do so->rcpt
   // pro 2. seznam spust generovn emailu, kde kad pjemce generuje email dle svho nastaven, pijemce pidej samostan do so->rcpt

   // napl informace o uivateli
   lcJID = smtp_GetJID(so->p,xmlnode_get_attrib(jp->x,"from"));
//   so->oJID=SMTP_GetItemRoster(lcJID,0);

   

   // from
   if (so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"J2S_FRMode"),0)==1 &&
       j_atoi(xmlnode_get_attrib(so->oJID,"UseGlobalSettings"),1)==0
      )
      {
      lcFRName=smtp_alltrim(xmlnode_get_attrib(so->oJID,"J2S_FRName"));
      if ( (lcFRAddr=smtp_alltrim(xmlnode_get_attrib(so->oJID,"J2S_FRAddr")))==NULL)
         lcFRAddr=pstrdup(tmpp,so->from);

      PM_Reg(7085, so->p,tmpp=pool_new(),1,NULL);
      if (j_strlen(lcFRName)>0)
         {
         tmp = (char*)pmalloco(tmpp, EQP_LENGTH(j_strlen(lcFRName)));
         toQP(lcFRName, (void *) tmp,0,SEQ_QP);
         lcFRName=spools(tmpp,"=?utf-8?q?",tmp,"?=",tmpp);
         }

      tmp = (char*)pmalloco(tmpp, EQP_LENGTH(j_strlen(lcFRAddr)));
      toEscape(lcFRAddr, (void *) tmp,SEQ_ESCAPE);
      lcFRAddr=tmp;

      if (j_strlen(lcFRName)>0)
         subject=spools(tmpp,"\"",lcFRName,"\" <",lcFRAddr,">" ,tmpp);
      else
         subject=spools(tmpp,"<",lcFRAddr,">" ,tmpp);

      xmlnode_put_attrib(so->x,"From",subject);
      pool_free(tmpp);
      }
   else
      xmlnode_put_attrib(so->x,"From",so->from);


   // to,cc, bcc elements
   if ((tagx=xmlnode_get_tag(jp->x,"addresses?xmlns=http://jabber.org/protocol/address"))) 
      {
       // read all childs elements from x element
      for (tagxchild = xmlnode_get_firstchild(tagx); tagxchild != NULL; tagxchild = xmlnode_get_nextsibling(tagxchild))
          {
	      if (tagxchild->type!=NTYPE_TAG)
		     continue;

          tocc=lcPom=smtp_GetSMTPAddress(xmlnode_get_attrib(tagxchild,"jid"));
          lii=j_strlen(tocc);
          PM_Reg(7081, so->p, tmpp=pool_new(),1,NULL);
          tmp = (char*)pmalloco(tmpp, EQP_LENGTH(lii));
          toEscape(tocc, (void *) tmp,SEQ_ESCAPE);

          if (j_strlen(tmp)>lii)
             {
             lcPom = (char*)pmalloc_x(tmpp, EQP_LENGTH(lii),' ');
             toQP(tocc, (void *) lcPom,0,SEQ_QP);
             }

          so->rcpt = jid_append(so->rcpt,jid_new(so->p,tmp));
          so->ircpt++;

          // is it to element?
          if (j_strcmp(xmlnode_get_attrib(tagxchild,"type"),"to")==0)
             smtp_out_add_recipient_to_lis(datato,tocc, tmp, lcPom, &lidatato);

          // is it cc element?
          if (j_strcmp(xmlnode_get_attrib(tagxchild,"type"),"cc")==0)
             smtp_out_add_recipient_to_lis(datacc,tocc, tmp, lcPom, &lidatacc);

          // is it bcc element?
          if (j_strcmp(xmlnode_get_attrib(tagxchild,"type"),"bcc")==0)
             smtp_out_add_recipient_to_lis(databcc,tocc, tmp, lcPom, &lidatabcc);

          pool_free(tmpp);
          }
      }
   else
      {
      lii=j_strlen(to);

      PM_Reg(7082,so->p, tmpp=pool_new(),1,NULL);
      tmp = (char*)pmalloco(tmpp, EQP_LENGTH(lii));
      toEscape(to, (void *) tmp,SEQ_ESCAPE);
      if (j_strlen(tmp)>lii)
         {
         lcPom = (char*)pmalloc_x(tmpp, EQP_LENGTH(lii),' ');
         toQP(to, (void *) lcPom,0,SEQ_QP);

         spooler(datato,"\"=?utf-8?q?",lcPom,"?=\" ","<",tmp,">",datato); // simple recipient
         }
      else
         spooler(datato,"<",tmp,">",datato); // simple recipient

      pool_free(tmpp);
      so->rcpt = jid_new(so->p,to);
      so->ircpt++;
      }



   if (datato->len>0)
      xmlnode_put_attrib(so->x,"to",spool_print(datato));

   if (datacc->len>0)
      xmlnode_put_attrib(so->x,"cc",spool_print(datacc));

   if (databcc->len>0)
      xmlnode_put_attrib(so->x,"bcc",spool_print(databcc));



   // napl informace o uivateli II
   loSubj=xmlnode_get_tag(jtin->config,"jabber/defaultaccount");

   so->oAD=xmlnode_get_tag(jtin->config,"jabber/ad");

   so->Advertising=0;
   if (so->oAD!=NULL && j_atoi(xmlnode_get_attrib(so->oAD,"enabled"),0)==1)
      {
      if (smtp_ispaid(lcJID,so->oJID)==0)
         so->Advertising=1;
      }


   if (loSubj!=NULL)
      so->toPGPMIME=j_atoi(xmlnode_get_attrib(loSubj,"PGPJabberToMIME"),1);

   if (so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"UseGlobalSettings"),1)==0)
      so->toPGPMIME=j_atoi(xmlnode_get_attrib(so->oJID,"PGPJabberToMIME"),1);


   if (loSubj!=NULL)
      {
      so->SRMode=j_atoi(xmlnode_get_attrib(loSubj,"J2S_SRMode"),2);
      so->SRSeparator=pstrdup(so->p,xmlnode_get_attrib(loSubj,"J2S_SRSeparator"));
      so->SRText=pstrdup(so->p,xmlnode_get_attrib(loSubj,"J2S_SRText"));
      }

   if (so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"UseGlobalSettings"),1)==0)
      {
      so->SRMode=j_atoi(xmlnode_get_attrib(so->oJID,"J2S_SRMode"),2);
      so->SRSeparator=pstrdup(so->p,xmlnode_get_attrib(so->oJID,"J2S_SRSeparator"));
      so->SRText=pstrdup(so->p,xmlnode_get_attrib(so->oJID,"J2S_SRText"));
      }

   // subject
   subject = pstrdup(so->p,smtp_alltrim(xmlnode_get_tag_data(jp->x,"subject")));
   if (loSubj && so->SRMode!=0)
      {
      if (j_strlen(subject)==0 && so->SRMode==3) // if empty and replace is 3
         subject=spools(so->p,so->SRText,so->p);

      if (j_strlen(subject)>0 && so->SRMode==1) // if not empty and replace is 1
         subject=spools(so->p,so->SRText," ",so->SRSeparator," ",subject,so->p);

      if (j_strlen(subject)>0 && so->SRMode==2) // if not empty and replace is 2
         subject=spools(so->p,subject," ",so->SRSeparator," ",so->SRText,so->p);

      }


   if (j_strlen(subject)==0)
      subject=smtp_rc_GetString(so->p,so->lang,SMTP_XXX_NOSUBJECT);


   if ((liLen=j_strlen(subject))>0)
      {
      PM_Reg(7083, so->p, tmpp=pool_new(),1,NULL);
      tmp = (char*)pmalloc_x(tmpp, EQP_LENGTH(liLen),' ');
      toQP(subject, (void *) tmp,0,SEQ_QP);
      xmlnode_put_attrib(so->x,"Subject",spools(tmpp,"=?utf-8?q?",tmp,"?=",tmpp));
      pool_free(tmpp);
      }

   // reply-to
   if (jp->subtype!=JPACKET__CHAT && so->oJID!=NULL &&
       j_atoi(xmlnode_get_attrib(so->oJID,"UseGlobalSettings"),1)==0 &&
       j_atoi(xmlnode_get_attrib(so->oJID,"J2S_RTMode"),0)==1
       )
      {

      lcRTName=smtp_alltrim(xmlnode_get_attrib(so->oJID,"J2S_RTName"));
      if ( (lcRTAddr=smtp_alltrim(xmlnode_get_attrib(so->oJID,"J2S_RTAddr")))==NULL)
         lcRTAddr=pstrdup(tmpp,so->from);

      PM_Reg(7084, so->p,tmpp=pool_new(),1,NULL);
      if (j_strlen(lcRTName)>0)
         {
         tmp = (char*)pmalloco(tmpp, EQP_LENGTH(j_strlen(lcRTName)));
         toQP(lcRTName, (void *) tmp,0,SEQ_QP);
         lcRTName=spools(tmpp,"=?utf-8?q?",tmp,"?=",tmpp);
         }

      tmp = (char*)pmalloco(tmpp, EQP_LENGTH(j_strlen(lcRTAddr)));
      toEscape(lcRTAddr, (void *) tmp,SEQ_ESCAPE);
      lcRTAddr=tmp;

      if (j_strlen(lcRTName)>0)
         subject=spools(tmpp,"\"",lcRTName,"\" <",lcRTAddr,">" ,tmpp);
      else
         subject=spools(tmpp,"<",lcRTAddr,">" ,tmpp);

      xmlnode_put_attrib(so->x,"Reply-to",subject);
      pool_free(tmpp);
      }

   xmlnode_put_attrib(so->x,"X-Mailer",spools(so->p,smtp_name," ",smtp_version," ","[http://gorila.netlab.cz/jabber.html]",so->p));
   xmlnode_put_attrib(so->x,"MIME-Version","1.0");
   xmlnode_put_attrib(so->x,"Jabber-ID",lcFrom);



   id=xmlnode_get_attrib(jp->x,"id");
   if (j_strlen(id)==0)
      {
      id = (char*)pmalloc_x(so->p, 18,' ');
      smtp_GetDateTime((char *)id);
      while ((lcPom = strstr(id, ":")) != NULL)
         {
         *lcPom='.';
         }

      }

   xmlnode_put_attrib(so->x,"Message-ID",spools(so->p,"<",id,"@",jtin->me,">",so->p));


   if (jp->subtype==JPACKET__CHAT)
      {
      if ((thread=xmlnode_get_tag(jp->x,"thread"))!= NULL)
         xmlnode_put_attrib(so->x,"X-Jabber-Thread-id",xmlnode_get_data(thread));
      else    
         xmlnode_put_attrib(so->x,"X-Jabber-Thread-id","jabber-start-thread");
      }

   /* create time header for message */
   now_unixtime = time(NULL);
   gmtime_r(&now_unixtime, &now);
   snprintf(dateheader, j_strlen(dateheader), "%02i %s %04i %02i:%02i:%02i +0000\0", now.tm_mday, smtp_CMonth(now.tm_mon), now.tm_year+1900, now.tm_hour, now.tm_min, now.tm_sec);
   if (dateheader[0])
 	   xmlnode_put_attrib(so->x,"Date",dateheader);


   loHTML=xmlnode_get_tag(jp->x,"html");
   loBody=xmlnode_get_tag(jp->x,"body");
   loEncrypted=xmlnode_get_tag(jp->x,"x?xmlns=jabber:x:encrypted"); // is used PGP?
   loSigned=xmlnode_get_tag(jp->x,"x?xmlns=jabber:x:signed"); // is used PGP?

   // convert any :x:  to text
// <x xmlns="jabber:x:oob">
//  <url>www.volny.cz/scepela</url> 
//  <desc>mrkni se</desc> 
//  </x>
// stop A
   tagx=xmlnode_get_tag(jp->x,"x?xmlns=jabber:x:oob");

  
   if (loEncrypted || loSigned)
      {
      liPGP=1;
      if (so->Advertising==1)
         liMode=SMTP_PGP_ATTACH;
      else
         liMode=(so->toPGPMIME==1)?SMTP_PGP_MIME:SMTP_PGP_NOMIME;
      }


   // PGP, encrypted or encrypted+signed
   if (loEncrypted!= NULL)
      {
      loCB=xmlnode_get_tag(jtin->config,"core/pgp/cbm/cb"); // comment block
      if (loCB)
         lcCB=xmlnode_get_data(loCB);

      switch(liMode)
         {
         case SMTP_PGP_ATTACH:
              snprintf(smtpboundary, j_strlen(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              smtpCT=spools(so->p, "multipart/mixed;\r\n boundary=\"",smtpboundary,"\"", so->p);

              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              // advertising message
              xmlnode_insert_cdata(so->x,"\r\n--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - Advertising\r\n\r\n",-1);

              xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // PGP message as attachment
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-encrypted;\r\n name=\"PGP encrypted message\";\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: attachment;\r\n filename=\"PGPEncryptedMessage.asc\"\r\n\r\n",-1);

              // PGP message
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loEncrypted),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);


              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;

         case SMTP_PGP_MIME:
              snprintf(smtpboundary, j_strlen(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              smtpCT=spools(so->p,"multipart/encrypted;\r\n protocol=\"application/pgp-encrypted\";\r\n boundary=\"",smtpboundary,"\"", so->p);

              // encrypted content type
              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              xmlnode_insert_cdata(so->x,"\r\nThis is an OpenPGP/MIME encrypted message (RFC 2440 and 3156)\r\n",-1);

              // Begin of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-encrypted\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: PGP/MIME version identification\r\n\r\nVersion: 1\r\n\r\n",-1);

              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: application/octet-stream; name=\"encrypted.asc\"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: OpenPGP encrypted message\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: inline; filename=\"encrypted.asc\"\r\n\r\n",-1);

              // PGP message
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loEncrypted),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);

              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;


         default:
              xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
              xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              // PGP message
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loEncrypted),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);
         }
      }

   // PGP, signed (only)
   if (loSigned!= NULL)
      {
      loCB=xmlnode_get_tag(jtin->config,"core/pgp/cbs/cb"); // comment block
      if (loCB)
         lcCB=xmlnode_get_data(loCB);

      switch(liMode)
         {
         case SMTP_PGP_ATTACH:
              snprintf(smtpboundary, j_strlen(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              smtpCT=spools(so->p, "multipart/mixed;\r\n boundary=\"",smtpboundary,"\"", so->p);

              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              // advertijting message
              xmlnode_insert_cdata(so->x,"\r\n--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - Advertising\r\n\r\n",-1);

              xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // PGP message as attachment
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-signature;\r\n name=\"PGP signature message\";\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit;\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: attachment;\r\n filename=\"PGPSignatureMessage.asc\"\r\n\r\n",-1);

              // PGP signature body
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loSigned),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);


              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;

         case SMTP_PGP_MIME:
              snprintf(smtpboundary, j_strlen(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              smtpCT=spools(so->p, "multipart/signed;\r\n protocol=\"application/signature\";\r\n boundary=\"",smtpboundary,"\"", so->p);


              // basic content type
              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");


              xmlnode_insert_cdata(so->x,"\r\nThis is an OpenPGP/MIME signed message (RFC 2440 and 3156)\r\n",-1);

              // Begin of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: Content-Type: text/plain; charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n\r\n",-1);
              // body text
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);


              // PGP signature
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-signature; name=\"signature.asc\"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: digital signature\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: attachment; filename=\"signature.asc\"\r\n\r\n",-1);


              // PGP signature body
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loSigned),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);

              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;


         default:
              xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
              xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              xmlnode_insert_cdata(so->x,SMTP_PGP_SIGNED_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"\r\nHash: SHA1",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // body text
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // PGP signed
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loSigned),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);
              break;

         }

      }


   // xhtml and text
   if (liPGP==0 && loHTML!= NULL && loBody!= NULL)
      {
      snprintf(smtpboundary, j_strlen(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
      smtpCT=spools(so->p, "multipart/alternative; boundary=\"",smtpboundary,"\"", so->p);

      xmlnode_put_attrib(so->x,"Content-type",smtpCT);

      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);

      xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - text format\r\n",-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);


      if (tagx!=NULL)
         {
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_tag_data(tagx,"desc"),-1);
         xmlnode_insert_cdata(so->x," ",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_tag_data(tagx,"url"),-1);
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         }



      // pidn podpisu jen pokud to nen chat
      if (jp->subtype!=JPACKET__CHAT && j_atoi(xmlnode_get_attrib(so->oJID,"J2S_ASMode"),0)==1 )
         {
         lii=0;
         for (loItem = xmlnode_get_firstchild(xmlnode_get_tag(so->oJID,"autosignature")); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
             {
             if (loItem->type!=NTYPE_TAG)
                 continue;

             if (lii==0)
                 xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

             xmlnode_insert_cdata(so->x,xmlnode_get_data(loItem),-1);
             xmlnode_insert_cdata(so->x,"\r\n",-1);
             lii=1;
             }
         }

      if (so->Advertising==1)
         {
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
       

      // for html is needly insert <head> tag with meta tag about charset
      // <head><meta content="text/html; charset=utf-8" http-equiv="content-type" /></head>

      html= xmlnode_new_tag_pool(so->p,"html");
      if (xmlnode_has_attribs(loHTML))
          xmlnode_insert_node(html, xmlnode_get_firstattrib(loHTML));

      meta=xmlnode_insert_tag(xmlnode_insert_tag(html,"head"),"meta");
      xmlnode_put_attrib(meta,"content-type","text/html; charset=utf-8");
      xmlnode_put_attrib(meta,"http-equiv","content-type");
      xmlnode_insert_node(html, xmlnode_get_firstchild(loHTML));

      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Type: text/html; charset=UTF-8\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - html format\r\n",-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,xmlnode2str(html),-1);


      if (tagx!=NULL)
         {
         xmlnode_insert_cdata(so->x,"\r\n<div>",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_tag_data(tagx,"desc"),-1);
         xmlnode_insert_cdata(so->x," ",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_tag_data(tagx,"url"),-1);
         xmlnode_insert_cdata(so->x,"</div>\r\n",-1);
         }

      // pidn podpisu jen pokud to nen chat
      if (jp->subtype!=JPACKET__CHAT && j_atoi(xmlnode_get_attrib(so->oJID,"J2S_ASMode"),0)==1)
         {
         lii=0;
         for (loItem = xmlnode_get_firstchild(xmlnode_get_tag(so->oJID,"autosignature")); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
             {
             if (loItem->type!=NTYPE_TAG)
                 continue;

             if (lii==0)
                 xmlnode_insert_cdata(so->x,"\r\n<br />",-1);

             xmlnode_insert_cdata(so->x,"\r\n<div>",-1);
             xmlnode_insert_cdata(so->x,xmlnode_get_data(loItem),-1);
             xmlnode_insert_cdata(so->x,"</div>",-1);
             lii=1;
             }
         }


      if (so->Advertising==1)
         {
         xmlnode_insert_cdata(so->x,"\r\n<div>",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         xmlnode_insert_cdata(so->x,"</div>",-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
       
      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
      }


   // only xhtml
   if (liPGP==0 && loHTML!= NULL && loBody== NULL)
      {
      html= xmlnode_new_tag_pool(so->p,"html");
      if (xmlnode_has_attribs(loHTML))
          xmlnode_insert_node(html, xmlnode_get_firstattrib(loHTML));

      meta=xmlnode_insert_tag(xmlnode_insert_tag(html,"head"),"meta");
      xmlnode_put_attrib(meta,"content-type","text/html; charset=utf-8");
      xmlnode_put_attrib(meta,"http-equiv","content-type");
      xmlnode_insert_node(html, xmlnode_get_firstchild(loHTML));

      xmlnode_put_attrib(so->x,"Content-Type","text/html; charset=UTF-8");
      xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
      xmlnode_put_attrib(so->x,"Content-Description","Jabber message - html format");
      xmlnode_insert_cdata(so->x,xmlnode2str(html),-1);


      if (tagx!=NULL)
         {
         xmlnode_insert_cdata(so->x,"\r\n<div>",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_tag_data(tagx,"desc"),-1);
         xmlnode_insert_cdata(so->x," ",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_tag_data(tagx,"url"),-1);
         xmlnode_insert_cdata(so->x,"</div>\r\n",-1);
         }

      // pidn podpisu jen pokud to nen chat
      if (jp->subtype!=JPACKET__CHAT && j_atoi(xmlnode_get_attrib(so->oJID,"J2S_ASMode"),0)==1)
         {
         lii=0;
         for (loItem = xmlnode_get_firstchild(xmlnode_get_tag(so->oJID,"autosignature")); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
             {
             if (loItem->type!=NTYPE_TAG)
                 continue;

             if (lii==0)
                 xmlnode_insert_cdata(so->x,"\r\n<br />",-1);

             xmlnode_insert_cdata(so->x,"\r\n<div>",-1);
             xmlnode_insert_cdata(so->x,xmlnode_get_data(loItem),-1);
             xmlnode_insert_cdata(so->x,"</div>",-1);

             lii=1;
             }
         }

      if (so->Advertising==1)
         {
         xmlnode_insert_cdata(so->x,"\r\n<div>",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         xmlnode_insert_cdata(so->x,"</div>",-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
      }


   // only text
   if (liPGP==0 && ((loHTML== NULL && loBody!= NULL) || tagx!=NULL) )
      {
      xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
      xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
      xmlnode_put_attrib(so->x,"Content-Description","Jabber message - text format");
      xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);

      if (tagx!=NULL)
         {
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_tag_data(tagx,"desc"),-1);
         xmlnode_insert_cdata(so->x," ",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_tag_data(tagx,"url"),-1);
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         }


      // pidn podpisu jen pokud to nen chat
      if (jp->subtype!=JPACKET__CHAT && j_atoi(xmlnode_get_attrib(so->oJID,"J2S_ASMode"),0)==1)
         {
         lii=0;
         for (loItem = xmlnode_get_firstchild(xmlnode_get_tag(so->oJID,"autosignature")); loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
             {
             if (loItem->type!=NTYPE_TAG)
                 continue;

             if (lii==0)
                 xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

             xmlnode_insert_cdata(so->x,xmlnode_get_data(loItem),-1);
             xmlnode_insert_cdata(so->x,"\r\n",-1);
             lii=1;
             }
         }


      if (so->Advertising==1)
         {
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
      }

   return so;
   }

/* read an incoming line from the connection */
void smtp_out_read(mio m, int state, void *arg, char *buffer, int bufsz)
   {
   char *cbuffer, *cur, *args,*lcBFile,*lcPom;
   int i,liSaved=0;
   jpacket jp;
   xmlnode x,loDescr,loJID;
   smtpsx par_so=(smtpsx)(arg);
   smtpp par =par_so->par;
   smtps so;
   pool p;
   spool loXXX;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"SMPT: MIO state %i, %s",state, buffer);
   #endif

   switch(state)
      {
      case MIO_CLOSED:
           so =par_so->so;
           #ifdef SMTP_DB
            SMTP_DEBUG(SMTP_ZONE,"SMPT: LAST COMMAND %i",so->lastcmd);
           #endif
           if (par_so->state==MIO_NEW)
              {
// pokud to sele pi voln z smtp_out_process_message/ smtp_in_recipient_cb, tak se neuzave puvodn pchoz smtp spojen
// bu se mus dan potebn strukutra pekoprovat, ukonit pchoz smtp spojen a pak smazat?!?
// nebo se odsu mus provst zbytek innosti (failed procedura + parametry).
              log_warn("smtp","MIO CONNECT FAILED, message save to offline folder");
              smtp_SendInfoToAdmin("MIO CONNECT FAILED, message save to offline folder",SMTP_SITA_P);

              if (par_so->gmCBF)
                 (*(smtp_j2s_cb)par_so->gmCBF)(so, par_so->gmArgF); // call procedure for generating so->x

              jtin->Stats->JabberMessagesOutError++;
              jtin->Stats->_JabberMessagesOutError++;
              smtp_StatsSave();
              log_warn("smtp","SMTP timeout error");


              // copy file from backup to offline folder
              if (jtin->tmpOfflineJabber==1 && jtin->tmpBackupJabber==1 && j_strlen(par_so->cBFile)>0)
                 {
                 lcBFile=spools(par_so->p, tempnam(jtin->jabber_offline, "tmp"),".xml",par_so->p);

                 if ((x=xmlnode_file(par_so->cBFile))==NULL)
                    rename(par_so->cBFile,lcBFile);
                 else
                    {
                    if ((loDescr=xmlnode_get_tag(x,"description"))==NULL)
                        loDescr=xmlnode_insert_tag(x,"description");

                    lcPom = (char*)pmalloc_x(par_so->p, 18,' ');
                    smtp_GetDateTime((char *)lcPom);
                    xmlnode_insert_cdata(loDescr,spools(par_so->p,lcPom," Time Out Error","\r\n",par_so->p),-1);
                    if (xmlnode2file(lcBFile,x)==1)
                       remove(par_so->cBFile);
                    else
                       rename(par_so->cBFile,lcBFile);

                    xmlnode_free(x);
                    }
               
                 par_so->cBFile=NULL;
                 liSaved=1;
                 }
//<remote-server-timeout/> wait 504 

              // Timeout error
              if (par->jp!=NULL && j_strcmp(jid_full(par->jp->from),jtin->met)!=0)
                 {
                 p= pool_new();
                 PM_Reg(7040, par_so->p,p,1,NULL);
                 loXXX=spool_new(p);

                 if (liSaved==1)
                    spooler(loXXX,smtp_rc_GetString(p,par_so->par->lang,SMTP_XXX_TIMEOUT_1),loXXX);
                 else
                    spooler(loXXX,smtp_rc_GetString(p,par_so->par->lang,SMTP_XXX_TIMEOUT_0),loXXX);

                 spooler(loXXX,"\r\n",xmlnode_get_tag_data(par->jp->x,"body"),loXXX);
                 loJID=SMTP_GetItemRoster(jid_full(par->jp->from),0);
                 smtp_SendInfoToAny(NULL,jid_full(par->jp->from), spool_print(loXXX) ,j_atoi(xmlnode_get_attrib(loJID,"SendSystemMessage"),SMTP_SITA_P),NULL);
                 pool_free(p);
                 xmlnode_free(loJID);
                 }
              pool_free(par_so->par->tmppool);
              }
           else if (so->lastcmd == CMD_DATAEND)
              {
              // delete email from backup repository
              #ifdef SMTP_DB
               SMTP_DEBUG(SMTP_ZONE,"TIMEOUT ERORR");
              #endif
              }
           else
              {
              // delete email from backup repository
              if (jtin->tmpBackupJabber==1 && j_strlen(par_so->cBFile)>0)
                 remove(par_so->cBFile);

              PM_SetItemTmp(par_so->so->p,1);
              }

           PM_SetItemTmp(par_so->p,1);
           pool_free(par_so->p);
           return;

      case MIO_ERROR:
           so =par_so->so;
           log_warn("smtp","MIO_ERROR, TIMEOUT ERROR AT sending message");
           smtp_SendInfoToAdmin("MIO_ERROR, TIMEOUT ERROR AT sending message",SMTP_SITA_P);
           jtin->Stats->JabberMessagesOutError++;
           jtin->Stats->_JabberMessagesOutError++;
           smtp_StatsSave();
           log_warn("smtp","SMTP timeout error");

           // copy file from backup to offline folder
           if (jtin->tmpOfflineJabber==1 && jtin->tmpBackupJabber==1 && j_strlen(par_so->cBFile)>0)
              {
              lcBFile=spools(so->p, tempnam(jtin->jabber_offline, "tmp"),".xml",so->p);


              if ((x=xmlnode_file(par_so->cBFile))==NULL)
                 rename(par_so->cBFile,lcBFile);
              else
                 {
                 if ((loDescr=xmlnode_get_tag(x,"description"))==NULL)
                     loDescr=xmlnode_insert_tag(x,"description");

                 lcPom = (char*)pmalloc_x(par_so->p, 18,' ');
                 smtp_GetDateTime((char *)lcPom);
                 xmlnode_insert_cdata(loDescr,spools(par_so->p,lcPom," Time Out Error","\r\n",par_so->p),-1);
                 if (xmlnode2file(lcBFile,x)==1)
                    remove(par_so->cBFile);
                 else
                    rename(par_so->cBFile,lcBFile);

                 xmlnode_free(x);
                 }
              par_so->cBFile=NULL;
              liSaved=1;
              }

           // Timeout error
           if (par->jp!=NULL && j_strcmp(jid_full(par->jp->from),jtin->met)!=0)
              {
              p= pool_new();
              PM_Reg(7050, so->p,p,1,NULL);
              loXXX=spool_new(p);

              if (liSaved==1)
                 spooler(loXXX,smtp_rc_GetString(p,par_so->par->lang,SMTP_XXX_TIMEOUT_1),loXXX);
              else
                 spooler(loXXX,smtp_rc_GetString(p,par_so->par->lang,SMTP_XXX_TIMEOUT_0),loXXX);

              spooler(loXXX,"\r\n",xmlnode_get_tag_data(so->jp->x,"body"),loXXX);
              smtp_SendInfoToAny(NULL,jid_full(so->jp->from), spool_print(loXXX) ,j_atoi(xmlnode_get_attrib(so->oJID,"SendSystemMessage"),SMTP_SITA_P),NULL);
              pool_free(p);
              }

           PM_SetItemTmp(par_so->so->p,1);
           PM_SetItemTmp(par_so->p,1);
           pool_free(par_so->p); // maybe bug?
           return;


      case MIO_NEW:
           #ifdef SMTP_DB
            SMTP_DEBUG(SMTP_ZONE,"SMPT: MIO_NEW\r\n");
           #endif
           par_so->state=MIO_BUFFER;
           // create so structure
           par_so->so=so = smtp_new_out(m);
           pool_cleanup(so->p, smtp_out_cleanup, (void *)so);
           PM_Reg(7004,par_so->p,so->p,0,(void*) par_so->so);

           if (par->jp!=NULL)
              {
              jabstats_add(par->jp);
              jp=so->jp = pmalloc(so->p,sizeof(_jpacket));
              jp->x = xmlnode_dup_pool(so->p,par->jp->x);
              jp=so->jp = jpacket_reset(jp);
              jpacket_subtype(jp);
              so->oJID=SMTP_GetItemRoster(smtp_GetJID(so->p,xmlnode_get_attrib(jp->x,"from")),1);
              }

           so->i = par->i;
           so->lang= pstrdup(so->p,par->lang);
           so->phase = PHASE_SEND;
           so->host = mio_ip(so->m);
           so->ircpt = 0;

           /* create xml for outgoing message */
           so->x = xmlnode_new_tag("mail");
           PM_Reg(7002, so->p,xmlnode_pool(so->x),0,NULL);

           pool_free(par->tmppool);

           (*(smtp_j2s_cb)par_so->gmCB)(so, par_so->gmArg); // call procedure for generating so->x

           mio_reset(m, smtp_out_read, (void *)par_so);

           return;

      case MIO_BUFFER:
           #ifdef SMTP_DB
            SMTP_DEBUG(SMTP_ZONE,"SMPT: MIO_BUFFER\r\n");
           #endif
           so =par_so->so;
           break;

      default:
           #ifdef SMTP_DB
            SMTP_DEBUG(SMTP_ZONE,"SMPT: MIO UNKNOWN STATE\r\n");
           #endif
           return;
      }


   so->timer = time(NULL); /* so we don't timeout */

   if(bufsz <= 0) return;

   if (so->buffer != NULL)
      { /* old data yet, combine and use that */
      cur = malloc(strlen(so->buffer) + bufsz + 1);
      *cur = '\0';
      strcat(cur,so->buffer);
      strcat(cur,buffer);
      free(so->buffer);
      so->buffer = buffer = cur;
      bufsz = strlen(buffer);
      }

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"phase %d data [%s]",so->phase, buffer);
   #endif
   cur = cbuffer = (char *)buffer;
   for(i = 1; i < bufsz; i++)
      {
      if (cbuffer[i-1] == '\r' && cbuffer[i] == '\n')
         {
         cbuffer[i-1] = '\0';
         cbuffer[i] = '\0';

         if (strlen(cur) > 0)
            {
            args = strstr(cur," ");
            if (args != NULL)
               {
               *args = '\0';
               ++args;
               }
            so->iStatus=atoi(cur);
            smtp_out_status(so,args);
            }
         cur = cbuffer + i + 1;
         }
      }

   free(so->buffer);
   so->buffer = NULL;
   i = strlen(cur);
   if (i > 0) /* the read was cut off */
      {
      so->buffer = strdup(cur);
      }

   }



void smtp_out_process_message(smtpp par, void *luCB, void *luArg, void *luCBF, void *luArgF)
   {
   pool p;
   smtpsx par_so;

   jtin->Stats->JabberMessages++;
   jtin->Stats->_JabberMessages++;
   smtp_StatsSave();

   p=pool_new();   

   par_so= pmalloc(p,sizeof(_smtpsx));
   par_so->p=p;
   par_so->state=MIO_NEW;
   par_so->par=par;
   par_so->gmArg=par_so->gmCBF=par_so->gmArgF= (void*) NULL;
   par_so->cBFile=NULL;

   PM_Reg(7000,NULL,p,0,(void*) par_so);

   
   par_so->gmCB=(void*) luCB;

   if (luCBF!=NULL)
      par_so->gmCBF=(void*) luCBF;

   if (luArg!=NULL)
       par_so->gmArg= (void*) luArg;

   if (luArgF!=NULL)
       par_so->gmArgF= (void*) luArgF;

   // save message to backup repository
   if (jtin->tmpBackupJabber==1 && par->jp!=NULL)
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"SMPT: save to backup folder\r\n");
      #endif
      par_so->cBFile = (char*)pmalloco(p, 254);
      par_so->cBFile[-1] = '\0';
      par_so->cBFile=spools(p, tempnam(jtin->jabber_backup, "tmp"),".xml",p);
      if (xmlnode2file(par_so->cBFile  ,par->jp->x)!=1)
         {
         smtp_SendInfoToAdmin(spools(p,"Save message to backup repository... ",par_so->cBFile," ...failed",p),SMTP_SITA_P );
         log_warn("smtp","Cannot save message to %s",par_so->cBFile);
         }
      }

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"Connect to SMTP... %s %i",jtin->relay,jtin->relayport);
   #endif
   mio_connect(jtin->relay, jtin->relayport, smtp_out_read, (void *)par_so, 30, NULL, NULL);

   }


// S:2005-09-01 gorila@dione.zcu.cz
int smtp_out_packets_message(smtpp par,char *lcType)
   {
   int liProcess=0,liErr,liLen;
   jpacket jp=par->jp;
   jid ljidFrom=smtp_2mx( jp->from);
   xmlnode xErr,loSubj;
   char *lcSubj=NULL,*lcJID, *lcPom;
   

// <message from='gorila@google.com' to='email.localhost' id='ab00a' type='error'><body>aaaaaaaaaaaaaa</body><error code='502'>Unable to deliver, destination unknown</error></message>
   // test to error
   if (jp->subtype == JPACKET__ERROR)
      {
      // it is error, but it not unknown recipient
      if ((liErr=j_atoi(xmlnode_get_attrib(xmlnode_get_tag(jp->x,"error"),"code"),0))!=404)
         return -1;

      // it is error - unknown recipient
      xErr=par->jp->x;
      lcPom=smtp_rc_GetString(par->tmppool,par->lang,SMTP_XXX_RCPT_NOTFOUND);

      if ((loSubj=xmlnode_get_tag(xErr,"subject"))!=NULL)
         {
         lcSubj=xmlnode_get_data(loSubj);
         xmlnode_hide(loSubj);
         }
      liLen=j_strlen(lcSubj)>0;

      loSubj=xmlnode_insert_tag(xErr,"subject");

      // pidej pedmt, jen pokud tam nen
      if (liLen==0 || strstr(lcSubj,lcPom)==NULL)
         {
         xmlnode_insert_cdata(loSubj,lcPom,-1);

         if (liLen>0)
            xmlnode_insert_cdata(loSubj,"  ",-1);
         }

      if (liLen>0)
         xmlnode_insert_cdata(loSubj,lcSubj,-1);

      smtp_out_process_message(par, (void*) smtp_out_new, NULL, NULL, NULL);
      liProcess=-2;
      }



   if (liProcess==0 && (jp->to == NULL || (jp->to->user!=NULL && strstr(jp->to->user,"%") == NULL) ||
       (ljidFrom == NULL && j_strcmp(jid_full(jp->from),jtin->met)!=0)))
      {
      deliver_fail(par->dp, "Invalid Address");
      liProcess=-1;
      }

   if (liProcess==0 && (jp->to->user == NULL && par->dp!=NULL)) // admin message
      {
      smtp_admin_message(par,lcType);
      liProcess=-1;
      }

   if (liProcess==0 && (jp->subtype==JPACKET__CHAT || jp->subtype==JPACKET__NONE))
      {
      /* hide session on the packet, and pass it to be handled after the conneciton is open */

      // test na JEP-0088, ignore it
      if (xmlnode_get_tag(jp->x,"composing")!=NULL ||
          xmlnode_get_tag(jp->x,"paused")!=NULL ||
          xmlnode_get_tag(jp->x,"inactive")!=NULL ||
          xmlnode_get_tag(jp->x,"gone")!=NULL
          )
      return -1;

      // ignore message has empty
      if (j_strlen(xmlnode_get_tag_data(jp->x,"body"))==0 &&
          j_strlen(xmlnode_get_tag_data(jp->x,"html"))==0 &&
          j_strlen(xmlnode_get_tag_data(jp->x,"subject"))==0
         )
         return -1;

      lcJID = smtp_GetJID(par->tmppool,xmlnode_get_attrib(jp->x,"from"));
      // check for registered users
      if (j_atoi(xmlnode_get_tag_data(jtin->config,"jabber/registered"),0)==1 &&
         SMTP_TestItemRoster(lcJID)==0)
         {
         deliver_fail(par->dp, smtp_rc_GetString(par->tmppool,par->lang,SMTP_XXX_MUST_REGISTER));
         return -1;
         }
      smtp_out_process_message(par, (void*) smtp_out_new, NULL, NULL, NULL);
      liProcess=-2; // upper routine doesn't free data;
      }

   return liProcess;
   }
// E:2005-09-01 gorila@dione.zcu.cz

void smtp_out_offline_message(xmlnode loMSG)
   {
   pool p;
   smtpp par;
   jpacket jp;

   // ignore message has empty
   if (j_strlen(xmlnode_get_tag_data(loMSG,"body"))==0 &&
       j_strlen(xmlnode_get_tag_data(loMSG,"html"))==0 &&
       j_strlen(xmlnode_get_tag_data(loMSG,"subject"))==0
      )
      {
      xmlnode_free(loMSG);
      return;
      }

   p=pool_new();   
   par= smtp_param_i(p,jtin->i);
   PM_Reg(7070,NULL, p,1,NULL);

   jp = pmalloc(p,sizeof(_jpacket));

   jp->x = xmlnode_dup_pool(p,loMSG);
   jp=par->jp = jpacket_reset(jp);
   jpacket_subtype(jp);

   xmlnode_free(loMSG);
   loMSG=NULL;

   if (smtp_2mx(jp->from)!=NULL)
      smtp_out_process_message(par, (void*) smtp_out_new, NULL, NULL, NULL);
   else
      pool_free(p);

   return;
   }


