#ifndef VERSION
 #include <jabberd.h>
#endif

#include "poolm.h"
#include "threads.h"

static PMI_struc PMI_Root; 
static void *PMI_Lost_cb=NULL;


/*
Structure of tree
0 (root)
|_ 5000 (group)
|
|_ 7000 (group)
    |
    |_123457850 (parent pool)
    |
    |_589563257 (parent pool)
          |
          |_232323212 (child pool) 

*/
PMI_struc _PM_CreateItem(int liGroup,pool pl,int liTmp)
   {
   PMI_struc b;
   pool p;
   b=pmalloco(p=pool_new(), sizeof(_PMI_struc));
   b->p=p; 
   b->pl=pl;
   b->parent=NULL;
   b->index=liGroup;
   b->last=b->next=b->child=NULL;
   b->tstamp=time(NULL);
   b->tmp=liTmp;
   return b;
   }



// find pool item in list
PMI_struc PM_FindItem(PMI_struc root,pool pl,PMI_struc *loPrev)
   {
   PMI_struc next=root,loItem=NULL;
   *loPrev=NULL;

   // check if pool in list
   while(next != NULL)
        {
        if (next->pl==pl)
           {
           loItem=next;
           break;
           }

        *loPrev=next;
        if (next->next != NULL)
           next = next->next;
        else
           break;
        }

   return loItem;
   }

// find pool in list
PMI_struc PM_Find(PMI_struc root,pool parent,pool pl,PMI_struc *loRoot,PMI_struc *loPrev)
   {
   PMI_struc next,loItem=NULL;
   *loPrev=NULL;

   if (parent!=NULL) // parent define, find it
      {
      next=PMI_Root;
      while(next != NULL)
           {
           if ((loItem=PM_FindItem(next->child,parent,loPrev))!=NULL) // find parent pool
              {

              *loRoot=loItem; // yeah, you found
              loItem=PM_FindItem(loItem->child,pl,loPrev); // try find pool in parent list
              break;
              }

           if (next->next != NULL)
              next = next->next;
           else
              break;
           }
      return loItem;
      }
   else
     {
      // if parent NULL, you must find all items in tree
      // check if pool in list
      next=root;
      while(next != NULL)
           {
           if (next->pl==pl)
              {
              loItem=next;
              break;
              }
           else if ((loItem=PM_FindItem(next->child,pl,loPrev))!=NULL)
              {
              *loRoot=next;
              break;
              }

           *loPrev=next;
           if (next->next != NULL)
              next = next->next;
           else
              break;
           }

     }
   return loItem;
   }

// Add group in list
PMI_struc _PM_AddGroup(int liGroup)
   {
   PMI_struc root=PMI_Root,last,b;
   b=_PM_CreateItem(liGroup,NULL,0);

   if (root == NULL)
      PMI_Root=b;
   else if ((last=root->last)==NULL) // save Last item
       {
       root->last=root->next=b;
       }
   else
      {
      last->next=b;
      root->last=b;
      }
   return b;
   }

// get group in list
PMI_struc PM_GetGroup(int liGroup)
   {
   PMI_struc b=NULL,next=PMI_Root;
   // check if group in list
   while(next != NULL)
        {
        if (next->index==liGroup)
           {
           b=next;
           break;
           }

        if (next->next != NULL)
           next = next->next;
        else
           break;
        }

   if (b==NULL) // if not found group, add it
      b=_PM_AddGroup(liGroup);

   return b;
   }



PMI_struc _PM_Reg(int liGroup,pool parent,pool pl, int liTmp,void *data)
   {
   PMI_struc loGroup,loItem=NULL,loLast,loRoot=NULL,loPrev;
   if (pl == NULL)
      return NULL;


   loGroup=PM_GetGroup(liGroup); // get group from list
   if ((loItem=PM_Find(loGroup->child,parent,pl,&loRoot,&loPrev))==NULL)
      {
      if (loRoot==NULL)
         loRoot=loGroup;


      loItem=_PM_CreateItem(liGroup,parent,liTmp);
      loItem->pl=pl;
      loItem->parent=parent;
      loItem->data=data;

      if (loRoot->child == NULL)
         {
         loRoot->child=loItem;
         }
      else if ((loLast=loRoot->child->last)==NULL) // save Last item
         {
         loRoot->child->last=loRoot->child->next=loItem;
         }
      else
         {
         loLast->next=loItem;
         loRoot->child->last=loItem;
         }
      }
   else
      loItem=NULL;

   return loItem;
   }

int _PM_Unreg(int liGroup,pool parent,pool pl)
   {
   PMI_struc loGroup,loItem,loPrev,loRoot=NULL;
   int liIndex=0;

   if (pl == NULL)
      return 0;

   loGroup=PM_GetGroup(liGroup); // get group from list
   if ((loItem=PM_Find(loGroup->child,parent,pl,&loRoot,&loPrev))!=NULL)
      {
      if (loRoot==NULL) loRoot=loGroup;

      if (loItem==loRoot->child && loItem->next==NULL) // root item
         {
         loRoot->child=NULL; // clear it
         }
      else if (loItem==loRoot->child && loItem->next!=NULL) // check to first item
         {
         loRoot->child=loItem->next;
         loRoot->child->last=loItem->last;
         }
      else if (loRoot->child->last==loItem) // check to last item
         {
         loRoot->child->last=loPrev; // copy last item to rootlast
         loPrev->next=NULL; // clear next item
         }
      else
         {
         loPrev->next=loItem->next;  // change next item
         }

      liIndex=loItem->index;
      pool_free(loItem->p); // free item
      }

   return liIndex;
   }

/* when the connection dies, clean up the mess */
void PM_Cleanup(void *arg)
   {
   PMI_struc loItem = (PMI_struc) arg;
   log_notice("PM","DAM: %10p %10p %06i",loItem->parent,loItem->pl,loItem->index);
   if (loItem->tmp==0)
      log_notice("PM","DAM-RPP: %10p %10p %06i",loItem->parent,loItem->pl,loItem->index);

   loItem->data=(void*) NULL;
   _PM_Unreg(loItem->index,loItem->parent,loItem->pl);
   }



void PM_Reg(int liGroup,pool parent,pool p,int liTmp,void *data)
   {
   // liGroup - Group of Pool
   // parent  - Parent Pool, can be NULL
   // p       - Pool
   // liTmp   - temporary flag
   // data    - pointer to data
   PMI_struc loItem;
   log_notice("PM","ALM: %10p %10p %06i", (int)parent, (int)p,liGroup);
   loItem=_PM_Reg(liGroup,parent,p,liTmp,data);
   pool_cleanup(p, PM_Cleanup, (void *) loItem);
   }



PMI_struc PM_GetItem(pool pl)
   {
   PMI_struc loRoot=NULL,loPrev=NULL;
   if (pl == NULL)
      return NULL;
   return PM_Find(PMI_Root->child,NULL,pl,&loRoot,&loPrev);
   }


void PM_SetItemTmp(pool pl,int liTmp)
   {
   PMI_struc loItem;
   loItem=PM_GetItem(pl);
   if (loItem)
      loItem->tmp=liTmp;
   return; 
   }

void PM_SetItemTmpEx(int liGroup,pool parent,pool pl,int liTmp)
   {
   PMI_struc loGroup,loItem,loRoot=NULL,loPrev=NULL;
   if (pl == NULL)
      return;


   loGroup=PM_GetGroup(liGroup); // get group from list
   if ((loItem=PM_Find(loGroup->child,parent,pl,&loRoot,&loPrev))!=NULL)
      loItem->tmp=liTmp;
   return; 
   }

int _PM_GetMemItem(PMI_struc loItem,int liType)
   {
   int lii=0;
   PMI_struc loItemX;

   if (loItem==NULL)
      return 0;

   if (liType==PM_MEMORY_CORE || liType==PM_MEMORY_ALL)
      lii+=pool_size(loItem->p);
   
   if (loItem->pl!=NULL && (liType==PM_MEMORY_DATA || liType==PM_MEMORY_ALL))
      lii+=pool_size(loItem->pl);

   loItemX=loItem->child;
   while(loItemX != NULL)
        {
        if (loItemX->child!=NULL) // if exist child item
            lii+=_PM_GetMemItem(loItemX, liType); // add sum too
        else
           {
           if (liType==PM_MEMORY_CORE || liType==PM_MEMORY_ALL)
              lii+=pool_size(loItemX->p);

           if (liType==PM_MEMORY_DATA || liType==PM_MEMORY_ALL)
              lii+=pool_size(loItemX->pl);

           }

        if (loItemX->next != NULL)
           loItemX = loItemX->next;
        else
           break;

        }
   return lii;
   }


int PM_GetMem(int liGroup,pool liPL, int liType)
   {
   PMI_struc loItem,loGroup,loRoot,loPrev;
   int lii=0;
   if (liGroup!=0) // group is defined
      {
      loGroup=PM_GetGroup(liGroup); // get group from list
      loItem=loGroup->child;
      if (liType==PM_MEMORY_CORE || liType==PM_MEMORY_ALL)
          lii+=pool_size(loGroup->p);

      while(loItem != NULL)
           {
           if (liPL==NULL || loItem->pl==liPL)
              lii+=_PM_GetMemItem(loItem,liType);

           if (loItem->next != NULL)
              loItem = loItem->next;
           else
              break;

           }
      }
   else if (liPL==NULL)
      {
      // I don't known group and poll. Sum all data
      loItem=PMI_Root;
      while(loItem != NULL)
           {
           lii+=_PM_GetMemItem(loItem,liType);

           if (loItem->next != NULL)
              loItem = loItem->next;
           else
              break;

           }
      }
   else
      {  // I know only pool
      loItem=PM_Find(NULL,NULL,liPL,&loRoot,&loPrev);
      if (loItem!=NULL)
         lii=_PM_GetMemItem(loItem,liType);
      }
    
   return lii;
   }




// ************************************************
// pool manager daemon
// ************************************************
// Walk tree
void _PM_WalkTree(_tud TUD,PMI_struc loRoot,time_t tstamp)
   {
   PMI_struc loNext=loRoot, loItem;
   char *lcPom;

   lcPom = (char*)pmalloc_x(TUD->p, 254,'\0');

   int liEnd=0;
   while(loNext != NULL)
        {
        loItem=loNext;

        if (loNext->next != NULL)
           loNext = loNext->next;
        else
           liEnd=1;

        _PM_WalkTree(TUD,loNext->child,tstamp);


        if (loItem->tmp==1 && tstamp>loItem->tstamp+60*PMI_TimeOut)
           {
           log_alert("PM","MEL: %011i, %06i",(int)loItem->pl,loItem->index);
           if (PMI_Lost_cb!=NULL)
              {
              snprintf(lcPom, 254, "POOL MANAGER DAEMON - MEMORY LEAK: %020ll, %06i.",loItem->pl,loItem->index);
              (*(pm_lost_cb)PMI_Lost_cb)((void*) lcPom);
              }

           _PM_Unreg(loItem->index,loItem->parent,loItem->pl);
           }

        if (liEnd==1)
           break;

        }
   }

// daemon thread
void PM_mtq(void *arg)
   {
   _tud TUD= (_tud) arg;
   time_t tstamp=time(NULL);

   // projdi seznam  v pool manageru
   // zkontroluj asovou znaku
   // ve co je tam dle jak 30 minut, uvolni a poli info adminovi

   _PM_WalkTree(TUD,PMI_Root,tstamp);

   PM_SetItemTmp(TUD->p,1);
   pool_free(TUD->p);
   }


// create new thread for getting paid flag
result PM_Daemon(void *arg)
   {
   _tud TUD=TU_NewData();

   PM_Reg(2100,NULL, TUD->p,0,NULL);

   mtq_send(TUD->q, TUD->p, PM_mtq, (void *)TUD);
   return r_DONE;
   }


// init of daemon
void PM_InitDaemon()
  {
  register_beat(60*PMI_TimeOut , PM_Daemon, (void *)NULL);
  }

// init of root
PMI_struc PM_InitRoot(void *arg)
  {
  PMI_Root=_PM_CreateItem(0,0,0);
  PMI_Lost_cb= arg;
  return PMI_Root;
  }
