#include "smtp.h"

extern smtpi jtin;

// Group section
// these function get/set group in roster
char *_SMTP_GetGroupFromJID(pool p,char *lcJID)
   {
   char *lcGroup;
   lcGroup = (char*)pmalloc_x(p, 3,'\0');
   lcGroup[0]=lcJID[0];
   if (lcJID[0]<0)
      lcGroup[1]=lcJID[1]; // copy second byte
   return lcGroup;
   }

smtp_rjids _SMTP_GetGroupRoster(char *lcGroup)
   {
   smtp_rjids next=jtin->roster,b=NULL;
   while(next != NULL)
        {
        if (j_strcmp(next->cGroup,lcGroup)==0)
           {
           b=next;
           break;
           }

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return b;
   }

smtp_rjids _SMTP_AppendGroupRoster(smtp_rjids loGroup)
   {
   smtp_rjids loRoot=jtin->roster,loLast;
   if (loGroup == NULL)
      return NULL;

   if (loRoot == NULL)
      {
      jtin->roster=loGroup;
      return loGroup;
      }

   if ((loLast=loRoot->last)==NULL) // save Last item
      {
      loRoot->last=loRoot->next=loGroup;
      }
   else
      {
      loLast->next=loGroup;
      loRoot->last=loGroup;
      }

   return loGroup;
   }

// Group section - END


// Item section
// these function get/set item in group roster

smtp_rjid _SMTP_GetItemRoster(smtp_rjids loGroup, char *lcJID)
   {
   smtp_rjid item=loGroup->item,b=NULL;
   while(item != NULL)
        {
        if (j_strcmp(item->cJID,lcJID)==0)
           {
           b=item;
           break;
           }

        if (item->next != NULL)
           item = item->next;
        else
           break;

        }
   return b;
   }

int _SMTP_TestItemRoster(smtp_rjids loGroup, char *lcJID)
   {
   smtp_rjid item=loGroup->item;
   int liExist=0;
   while(item != NULL)
        {
        if (j_strcmp(item->cJID,lcJID)==0)
           {
           liExist=1;
           break;
           }

        if (item->next != NULL)
           item = item->next;
        else
           break;

        }
   return liExist;
   }

smtp_rjid _SMTP_AppendItemRoster(smtp_rjids loGroup, smtp_rjid loItem)
   {
   smtp_rjid loRoot=loGroup->item,loLast;
   if (loItem == NULL)
      return NULL;

   if (loRoot == NULL)
      {
      loGroup->item=loItem;
      return loItem;
      }

   if ((loLast=loRoot->last)==NULL) // save Last item
      {
      loRoot->last=loRoot->next=loItem;
      }
   else
      {
      loLast->next=loItem;
      loRoot->last=loItem;
      }

   return loItem;
   }

smtp_rjid _SMTP_CreateItemRoster(char *lcJID)
   {
   smtp_rjid loItem;
   pool p;
   loItem=pmalloco(p=pool_new(), sizeof(_smtp_rjid));
   PM_Reg(6010,NULL, p,0,(void*) loItem);

   loItem->p=p;
   loItem->oData=NULL;
   loItem->cJID=pstrdup(p,lcJID);
   loItem->next=loItem->last=NULL;
   return loItem;
   }

void _SMTP_DropItemRoster(smtp_rjids loGroup,char *lcJID)
   {
   smtp_rjid loRoot=loGroup->item,loItem=loGroup->item,loPrev;
   if (lcJID==NULL)
       return;

   while(loItem != NULL)
        {
        if (j_strcmp(loItem->cJID,lcJID)==0)
           {
           if (loItem==loRoot && loItem->next==NULL) // root item
              loGroup->item=NULL; // clear it
           else if (loItem==loRoot && loItem->next!=NULL) // check to first item
              {
              loGroup->item=loItem->next;
              loGroup->item->last=loItem->last;
              }
           else if (loRoot->last==loItem) // check to last item
              {
              loRoot->last=loPrev; // copy last item to rootlast
              loPrev->next=NULL; // clear next item
              }
           else
              loPrev->next=loItem->next;  // change next item

           PM_SetItemTmp(xmlnode_pool(loItem->oData),1);
           PM_SetItemTmp(loItem->p,1);
           xmlnode_free(loItem->oData); // free item data
           pool_free(loItem->p); // free item
           break;
           }

        loPrev=loItem;
        if (loItem->next != NULL)
           loItem = loItem->next;
        else
           break;
        }

   return;
   }


// Item section - END

void SMTP_SetItemRoster(xmlnode loRI,int liSave)
   {
   smtp_rjids loGroup=NULL;
   smtp_rjid loItem=NULL;
   pool p,pg;
   int liWas=1;
   char *lcGroup,*lcJID=xmlnode_get_attrib(loRI,"jid"),*lcFile;
   xmlnode loSave;

   if (loRI==NULL) return ;

   p=pool_new();
   PM_Reg(6020,NULL, p,1,NULL);

   // get group from JID
   lcGroup=_SMTP_GetGroupFromJID(p,lcJID);

   // check if group exist
   if ((loGroup=_SMTP_GetGroupRoster(lcGroup))==NULL) // group not exist, create it
      {
      loGroup=pmalloco(pg=pool_new(), sizeof(_smtp_rjids));
      PM_Reg(6000,NULL, pg,0,(void*) loGroup); //
      
      loGroup->p=pg;
      loGroup->item=NULL;
      loGroup->cGroup=pstrdup(pg,lcGroup);
      loGroup->next=loGroup->last=NULL;

      _SMTP_AppendGroupRoster(loGroup);
      }
   else // group exist, find JID in group
      loItem=_SMTP_GetItemRoster(loGroup,lcJID);
      

   // if not item exist 
   if (loItem==NULL) // create it
      {
      loItem=_SMTP_CreateItemRoster(lcJID);
      liWas=0;
      }
   else
      if (loItem->oData!=NULL) // if any data exist, remember pointer
         {
         PM_SetItemTmp(xmlnode_pool(loItem->oData),1);
         xmlnode_free(loItem->oData); // free it
         }


   loItem->oData=xmlnode_dup(loRI);
   PM_Reg(6012, NULL,xmlnode_pool(loItem->oData),0,(void*) loItem->oData); // 

   if (liWas==0) // if not item exist, append it to group
      _SMTP_AppendItemRoster(loGroup,loItem);

   if (liSave==1)
      {
      lcFile=spools(p,jtin->roster_folder,"/",lcGroup,"/",lcJID,".ai.xml",p);
      smtp_CreateFolder(spools(p,jtin->roster_folder,"/",lcGroup,p));
      loSave=xmlnode_dup(loItem->oData);
      PM_Reg(6142, NULL,xmlnode_pool(loSave),0,(void*) loSave); // 
      if (xmlnode2file(lcFile,loSave)!=1)
         {
         log_alert("smtp","ROSTER - Cannot save roster-account file %s.",lcFile);
         smtp_SendInfoToAdmin(spools(p,"ROSTER - Cannot save contacts-account file ",lcFile,".",p ),SMTP_SITA_P);
         }
      PM_SetItemTmp(xmlnode_pool(loSave),1);
      xmlnode_free(loSave);
      }

   pool_free(p);
   }


xmlnode SMTP_GetItemRoster(char *lcJID, int liDefault)
   {
   smtp_rjids loGroup=NULL;
   smtp_rjid loItem=NULL;
   xmlnode loJID=NULL,loDA;
   pool p;
   char *lcGroup;

   p=pool_new();
   PM_Reg(6030,NULL, p,1,NULL);

   // get group from JID
   lcGroup=_SMTP_GetGroupFromJID(p,lcJID);

   // check if group exist
   if ((loGroup=_SMTP_GetGroupRoster(lcGroup))!=NULL) // group exist, find JID in group
      loItem=_SMTP_GetItemRoster(loGroup,lcJID);

   // if not item exist 
   if (loItem==NULL) // create it
      {
      if (liDefault==1)  // Get default item roster data
         {
         loDA=xmlnode_get_tag(jtin->config,"jabber/defaultaccount");

         loJID=xmlnode_new_tag("item");
         xmlnode_put_attrib(loJID,"jid",lcJID);
         xmlnode_put_attrib(loJID,"paid","0");
         xmlnode_put_attrib(loJID,"UseGlobalSettings","0");
         xmlnode_put_attrib(loJID,"SendSystemMessage","3");
         xmlnode_put_attrib(loJID,"Attachments",xmlnode_get_attrib(loDA,"Attachments"));
         xmlnode_put_attrib(loJID,"PGPJabberToMIME",xmlnode_get_attrib(loDA,"PGPJabberToMIME"));

         xmlnode_put_attrib(loJID,"S2J_AllAreSPAM",xmlnode_get_attrib(loDA,"S2J_AllAreSPAM"));
         xmlnode_put_attrib(loJID,"S2J_OutputMode","0");

         xmlnode_put_attrib(loJID,"J2S_RTMode","0");
         xmlnode_put_attrib(loJID,"J2S_RTName",lcJID);
         xmlnode_put_attrib(loJID,"J2S_RTAddr",lcJID);
         xmlnode_put_attrib(loJID,"J2S_ASMode","1");

         xmlnode_put_attrib(loJID,"J2S_FRMode","0");
         xmlnode_put_attrib(loJID,"J2S_FRName",lcJID);
         xmlnode_put_attrib(loJID,"J2S_FRAddr",lcJID);


         if ( loDA!=NULL)
            {
            xmlnode_put_attrib(loJID,"J2S_SRMode",xmlnode_get_attrib(loDA,"J2S_SRMode"));
            xmlnode_put_attrib(loJID,"J2S_SRSeparator",xmlnode_get_attrib(loDA,"J2S_SRSeparator"));
            xmlnode_put_attrib(loJID,"J2S_SRText",xmlnode_get_attrib(loDA,"J2S_SRText"));
            }

         loDA=xmlnode_get_tag(jtin->config,"smtp/defaultaccount");
         if ( loDA!=NULL)
            {
            xmlnode_put_attrib(loJID,"S2J_SRMode",xmlnode_get_attrib(loDA,"S2J_SRMode"));
            xmlnode_put_attrib(loJID,"S2J_SRSeparator",xmlnode_get_attrib(loDA,"S2J_SRSeparator"));
            xmlnode_put_attrib(loJID,"S2J_SRText",xmlnode_get_attrib(loDA,"S2J_SRText"));
            xmlnode_put_attrib(loJID,"PGPToJabbernonMIMETox",xmlnode_get_attrib(loDA, "PGPToJabbernonMIMETox"));
            }
         xmlnode_put_attrib(loJID,"default","1"); // flag of default item
         }
      }
   else
      {
      loJID=xmlnode_dup(loItem->oData);
      if (j_strlen(xmlnode_get_attrib(loJID,"J2S_RTMode"))==0)
         {  // backward compatibility
         xmlnode_put_attrib(loJID,"J2S_RTMode","0");
         xmlnode_put_attrib(loJID,"J2S_RTName",lcJID);
         xmlnode_put_attrib(loJID,"J2S_RTAddr",lcJID);
         }

      if (j_strlen(xmlnode_get_attrib(loJID,"J2S_FRMode"))==0)
         {  // backward compatibility
         xmlnode_put_attrib(loJID,"J2S_FRMode","0");
         xmlnode_put_attrib(loJID,"J2S_FRName",lcJID);
         xmlnode_put_attrib(loJID,"J2S_FRAddr",lcJID);
         }

       if (xmlnode_get_attrib(loJID,"J2S_ASMode")==NULL)
           xmlnode_put_attrib(loJID,"J2S_ASMode","1");

       if (xmlnode_get_attrib(loJID,"SendSystemMessage")==NULL)
          xmlnode_put_attrib(loJID,"SendSystemMessage","3");

       if (xmlnode_get_attrib(loJID,"S2J_OutputMode")==NULL)
          xmlnode_put_attrib(loJID,"S2J_OutputMode","0");

       if (xmlnode_get_attrib(loJID,"paid")==NULL)
          xmlnode_put_attrib(loJID,"paid","0");

      }

   pool_free(p);

   if (loJID!=NULL) // if any data exist, register it
      PM_Reg(6040,NULL, xmlnode_pool(loJID),1,NULL);
   return loJID;
   }

void SMTP_DropItemRoster(char *lcJID)
   {
   smtp_rjids loGroup=NULL;
   pool p;
   char *lcGroup,*lcFile;

   p=pool_new();
   PM_Reg(6050,NULL, p,1,NULL);

   // get group from JID
   lcGroup=_SMTP_GetGroupFromJID(p,lcJID);

   // check if group exist
   if ((loGroup=_SMTP_GetGroupRoster(lcGroup))!=NULL) // group exist, remove JID from group
      {
      _SMTP_DropItemRoster(loGroup,lcJID);
      lcFile=spools(p,jtin->roster_folder,"/",lcGroup,"/",lcJID,".ai.xml",p);
      if (remove(lcFile)!=0)
         {
         log_alert("smtp","ROSTER - Cannot remove roster-account file %s.",lcFile);
         smtp_SendInfoToAdmin(spools(p,"ROSTER - Cannot remove account file ",lcFile,".",p ),SMTP_SITA_P);
         }

      lcFile=spools(p,jtin->roster_folder,"/",lcGroup,"/",lcJID,".cl.xml",p);
      if (remove(lcFile)!=0)
         {
         log_alert("smtp","ROSTER - Cannot remove roster-account file %s.",lcFile);
         smtp_SendInfoToAdmin(spools(p,"ROSTER - Cannot remove contacts file ",lcFile,".",p ),SMTP_SITA_P);
         }
      }

   pool_free(p);
   return ;
   }

int SMTP_TestItemRoster(char *lcJID)
   {
   smtp_rjids loGroup=NULL;
   int liExist=0;
   pool p;
   char *lcGroup;

   p=pool_new();
   PM_Reg(6060,NULL, p,1,NULL);

   // get group from JID
   lcGroup=_SMTP_GetGroupFromJID(p,lcJID);

   // check if group exist
   if ((loGroup=_SMTP_GetGroupRoster(lcGroup))!=NULL) // group exist, find JID in group
      liExist=_SMTP_TestItemRoster(loGroup,lcJID);

   pool_free(p);
   return liExist;
   }


int SMTP_GetItemCountRoster(int liType)
   {
   smtp_rjids loGroup=jtin->roster;
   smtp_rjid  loItem;
   int lii=0;
   while(loGroup != NULL)
        {
        loItem=loGroup->item;
        while(loItem != NULL)
             {
             if (liType==SMTP_ACCOUNT_ALL || j_atoi(xmlnode_get_attrib(loItem->oData,"paid"),0)!=0)
                lii++;

             if (loItem->next != NULL)
                loItem = loItem->next;
             else
                break;
             }

        if (loGroup->next != NULL)
           loGroup = loGroup->next;
        else
           break;
        }
   return lii;
   }


int SMTP_GetItemMemRoster(int liType,char *lcJID)
   {
   smtp_rjids loGroup=jtin->roster;
   smtp_rjid  loItem;
   int lii=0;
   while(loGroup != NULL)
        {
        loItem=loGroup->item;
        if (liType==SMTP_MEMORY_CORE || liType==SMTP_MEMORY_ALL)
           lii+=pool_size(loItem->p);

        while(loItem != NULL)
             {
             if (liType==SMTP_MEMORY_CORE || liType==SMTP_MEMORY_ALL)
                lii+=pool_size(loItem->p);

             if (liType==SMTP_MEMORY_DATA || liType==SMTP_MEMORY_ALL || (liType==SMTP_MEMORY_JID && j_strcmp(loItem->cJID,lcJID)==0))
                lii+=pool_size(xmlnode_pool(loItem->oData));

             if (loItem->next != NULL)
                loItem = loItem->next;
             else
                break;
             }

        if (loGroup->next != NULL)
           loGroup = loGroup->next;
        else
           break;
        }
   return lii;
   }


//*****************************************************************
//*****************************************************************
//*****************************************************************
//*****************************************************************
smtp_cjid smtp_cjidNew(xmlnode loNode,char *lcJID)
   {
   smtp_cjid item;
   pool p;

   if (loNode==NULL && lcJID==NULL)
      return NULL;

   item=pmalloco(p=pool_new(), sizeof(_smtp_cjid));
   PM_Reg(6070, NULL, p,0,(void*) item); //
   item->p=p;

   if (loNode==NULL)
      {
      item->item=xmlnode_new_tag("item");
      item->cJID=pstrdup(p,lcJID);
      xmlnode_put_attrib(item->item,"jid",lcJID);
      }
   else
      {
      item->item=xmlnode_dup(loNode);
      item->cJID=pstrdup(p,xmlnode_get_attrib(loNode,"jid"));
      }

   item->offitem=xmlnode_new_tag_pool(xmlnode_pool(item->item),"item");
   item->next=item->last=NULL;
   item->iLogin=0;

   PM_Reg(6080,item->p, xmlnode_pool(item->item),0, (void*) item->item); //

   return item;
   }


smtp_cjid smtp_cjidGet(char *lcJID)
   {
   smtp_cjid next=jtin->ContactList,b=NULL;
   while(next != NULL)
        {
        if (j_strcmp(next->cJID,lcJID)==0)
           {
           b=next;
           break;
           }

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return b;
   }


smtp_cjid smtp_cjidAppend(smtp_cjid b)
   {
   smtp_cjid root=jtin->ContactList,last;
   if (b == NULL)
      return NULL;

   if (root == NULL)
      {
      jtin->ContactList=b;
      return b;
      }

   if ((last=root->last)==NULL) // save Last item
      root->last=root->next=b;
   else
      {
      last->next=b;
      root->last=b;
      }

   return b;
   }


void smtp_cjidDel(char *lcJID)
   {
   smtp_cjid root=jtin->ContactList,next=jtin->ContactList,prev;
   if (lcJID==NULL)
       return;

   while(next != NULL)
        {
        if (j_strcmp(next->cJID,lcJID)==0)
           {
           if (next==root && next->next==NULL) // root item
              jtin->ContactList=NULL; // clear it
           else if (next==root && next->next!=NULL) // check to first item
              {
              jtin->ContactList=next->next;
              jtin->ContactList->last=next->last;
              }
           else if (root->last==next) // check to last item
              {
              root->last=prev; // copy last item to rootlast
              prev->next=NULL; // clear next item
              }
           else
              prev->next=next->next;  // change next item

           PM_SetItemTmp(next->p,1);
           pool_free(next->p); // free item
           break;
           }

        prev=next;
        if (next->next != NULL)
           next = next->next;
        else
           break;
        }
   return ;
   }


int smtp_cjidGetCount(int liFlag)
   {
   int lii=0;
   smtp_cjid next=jtin->ContactList;
   xmlnode loJID;
   
   while(next != NULL)
        {
        if (liFlag==0)
           lii++;
        else
           {
           // get paid flag from roster
           loJID=SMTP_GetItemRoster(xmlnode_get_attrib(next->item,"jid") ,0);
           if (loJID!=NULL && j_atoi(xmlnode_get_attrib(loJID,"paid"),0)!=0)
               lii++;

           xmlnode_free(loJID);
           }


        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return lii;
   }


int SMTP_GetItemMemCL(int liType,char *lcJID)
   {
   int lii=0;
   smtp_cjid next=jtin->ContactList;
   
   while(next != NULL)
        {
        if (liType==SMTP_MEMORY_CORE || liType==SMTP_MEMORY_ALL)
           lii+=pool_size(next->p);

        if (liType==SMTP_MEMORY_DATA || liType==SMTP_MEMORY_ALL || (liType==SMTP_MEMORY_JID && j_strcmp(next->cJID,lcJID)==0))
           lii+=pool_size(xmlnode_pool(next->item));

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return lii;
   }


int smtp_cjidGetContactsCount()
   {
   int lii=0;
   smtp_cjid next=jtin->ContactList;
   xmlnode loTo;

   
   while(next != NULL)
        {

        for (loTo = xmlnode_get_tag(next->item,"to"); loTo != NULL; loTo = xmlnode_get_nextsibling(loTo))
            {
            if (loTo->type!=NTYPE_TAG)
                continue;

            lii++;
            }

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return lii;
   }


int smtp_online_add_item(char *lcFrom, char *lcTo)
   {
   xmlnode loTo,loOnI, loOffI;
   smtp_cjid loItem;
   int liCount=0;
   char *lcFile,*lcGroup;
   pool p=pool_new();
   PM_Reg(6090,NULL, p,1,NULL);

   if ((loItem=smtp_cjidGet(lcFrom))==NULL) // find item in list
      {
      smtp_cjidAppend(loItem=smtp_cjidNew(NULL,lcFrom)); // not exist add it
      }

   // check to item
   if (j_strlen(lcTo)>0)
      {
      if ((loTo=xmlnode_get_tag(loItem->item,spools(p,"to=",lcTo,p)))==NULL)
         {
         // record is not exist, create it
         // check if exist subitem in offline list
         if ((loTo=xmlnode_get_tag(loItem->offitem,spools(p,"to=",lcTo,p)))==NULL)
            {
            xmlnode_insert_cdata(loTo=xmlnode_insert_tag(loItem->item,"to"),lcTo,-1);
            }
         else
            {
            xmlnode_move_node(loTo, loItem->offitem, loItem->item);
            }

          liCount=1;
         }
      }
   else
      {
      loItem->iLogin=1;
      for (loTo = xmlnode_get_tag(loItem->offitem,"to"); loTo != NULL; loTo = xmlnode_get_tag(loItem->offitem,"to"))
          {
          if (loTo->type!=NTYPE_TAG)
      	    continue;

          xmlnode_move_node(loTo, loItem->offitem, loItem->item);
          liCount++;
          }
      }

   // remember data pointers
   loOnI=loItem->item;
   loOffI=loItem->offitem;

   // create new data 
   loItem->item=xmlnode_dup(loOnI);
   loItem->offitem=xmlnode_dup_pool(xmlnode_pool(loItem->item),loOffI);
   PM_Reg(6100, loItem->p,xmlnode_pool(loItem->item),0,(void*)loItem->item); //
   
   if (liCount>0)
      {
      // get group from JID
      lcGroup=_SMTP_GetGroupFromJID(p,lcFrom);
      lcFile=spools(p,jtin->roster_folder,"/",lcGroup,"/",lcFrom,".cl.xml",p);
      smtp_CreateFolder(spools(p,jtin->roster_folder,"/",lcGroup,p));
      if (xmlnode2file(lcFile,loOnI)!=1)
         {
         log_alert("smtp","ROSTER contacts - Cannot save roster-contacts file %s.",lcFrom);
         smtp_SendInfoToAdmin(spools(p,"ROSTER contacts - Cannot save contacts-letter file ",lcFrom,".",p ),SMTP_SITA_P);
         }
      }

   // free old data 
   PM_SetItemTmpEx(6100,loItem->p,xmlnode_pool(loOnI),1);
   xmlnode_free(loOnI);

   pool_free(p);
   return liCount;
   }

int smtp_online_remove_item(char *lcFrom, char *lcTo)
   {
   xmlnode loTo,loOnI, loOffI;
   smtp_cjid loItem;
   int liCount=0,liDele=0;
   char *lcFile,*lcGroup;
   pool p;

   if ((loItem=smtp_cjidGet(lcFrom))==NULL) // find item in list
      return 0;      // record is not exist

   p=pool_new();
   PM_Reg(6110,NULL,p,1,NULL);

   if (j_strlen(lcTo)>0) // remove sub item
      {
      // check to item
      if ((loTo=xmlnode_get_tag(loItem->item,spools(p,"to=",lcTo,p)))!=NULL)
         {
         liCount=1;
         xmlnode_move_node(loTo, loItem->item, loItem->offitem);
         }
      }
   else
      {
      // move subitems to offline, walk all item 
      for (loTo = xmlnode_get_tag(loItem->item,"to"); loTo != NULL; loTo = xmlnode_get_nextsibling(loTo))
          {
          if (loTo->type!=NTYPE_TAG)
      	    continue;

          liCount++;
          }
      }

   if (j_strlen(lcTo)==0 || xmlnode_get_tag(loItem->item,"to")==NULL)
      {
      smtp_cjidDel(lcFrom);
      liDele=1;
      }


   // remember data pointers
   loOnI=loItem->item;
   loOffI=loItem->offitem;

   // create new data 
   loItem->item=xmlnode_dup(loOnI);
   loItem->offitem=xmlnode_dup_pool(xmlnode_pool(loItem->item),loOffI);
   PM_Reg(6120, loItem->p,xmlnode_pool(loItem->item),0,(void*) loItem->item); //
   

   // get group from JID
   lcGroup=_SMTP_GetGroupFromJID(p,lcFrom);
   lcFile=spools(p,jtin->roster_folder,"/",lcGroup,"/",lcFrom,".cl.xml",p);
   if (liDele==0 && xmlnode2file(lcFile,loOnI)!=1)
      {
      log_alert("smtp","ROSTER contacts - Cannot save roster-contacts file %s.",lcFrom);
      smtp_SendInfoToAdmin(spools(p,"ROSTER contacts - Cannot save contacts-letter file ",lcFrom,".",p ),SMTP_SITA_P);
      }

   // free old data 
   PM_SetItemTmpEx(6120,loItem->p,xmlnode_pool(loOnI),1);
   xmlnode_free(loOnI);

   if (liDele==1)
      // Delete file 
      remove(lcFile);

   pool_free(p);
   return liCount;
   }


xmlnode smtp_online_get_item(char *lcFrom, char *lcTo, int liDefault)
   {
   xmlnode loTo=NULL;
   smtp_cjid loItem;
   pool p=pool_new();
   PM_Reg(6130,NULL, p,1,NULL);
   int liNew=0;

   if ((loItem=smtp_cjidGet(lcFrom))==NULL) // find item in list
      smtp_cjidAppend(loItem=smtp_cjidNew(NULL,lcFrom)); // not exist add it

   if ((loTo=xmlnode_get_tag(loItem->item,spools(p,"to=",lcTo,p)))==NULL)
      {
      if ((loTo=xmlnode_get_tag(loItem->offitem,spools(p,"to=",lcTo,p)))==NULL)
         {
         if (liDefault==1) // get default data
            {
            xmlnode_insert_cdata(loTo=xmlnode_new_tag("to"),lcTo,-1);
            liNew=1;
            }
         }
      else
         {
         loTo=xmlnode_dup(loTo);
         }
      }
   else
      {
      loTo=xmlnode_dup(loTo);
      }

   if (loTo!=NULL)
      PM_Reg(6132, NULL,xmlnode_pool(loTo),0,(void*)loTo); //
   
   pool_free(p);
   return loTo;
   }

void smtp_online_set_item(char *lcFrom, xmlnode loTo)
   {
   smtp_cjid loItem;
   char *lcFile,*lcGroup;
   pool p;
   xmlnode loOnI, loOffI,loToX,loIX;


   if ((loItem=smtp_cjidGet(lcFrom))==NULL) // find item in list
      smtp_cjidAppend(loItem=smtp_cjidNew(NULL,lcFrom)); // not exist add it

   p=pool_new();
   PM_Reg(6140,NULL,p,1,NULL);

   // check to old item
   loIX=loItem->item;
   if ((loToX=xmlnode_get_tag(loItem->item,spools(p,"to=",xmlnode_get_data(loTo),p)))!=NULL)
      xmlnode_hide(loToX); // if exist, hide it
   else
      if ((loToX=xmlnode_get_tag(loItem->offitem,spools(p,"to=",xmlnode_get_data(loTo),p)))!=NULL)
         {
         xmlnode_hide(loToX); // if exist, hide it
         loIX=loItem->offitem;
         }

  
   xmlnode_insert_node(loIX,loTo); // insert new tag

   // remember data pointers
   loOnI=loItem->item;
   loOffI=loItem->offitem;

   // create new data 
   loItem->item=xmlnode_dup(loOnI);
   loItem->offitem=xmlnode_dup_pool(xmlnode_pool(loItem->item),loOffI);
   PM_Reg(6120, loItem->p,xmlnode_pool(loItem->item),0,(void*) loItem->item); //
   

   // get group from JID
   lcGroup=_SMTP_GetGroupFromJID(p,lcFrom);
   lcFile=spools(p,jtin->roster_folder,"/",lcGroup,"/",lcFrom,".cl.xml",p);
   smtp_CreateFolder(spools(p,jtin->roster_folder,"/",lcGroup,p));
   if (xmlnode2file(lcFile,loOnI)!=1)
      {
      log_alert("smtp","ROSTER contacts - Cannot save roster-contacts file %s.",lcFrom);
      smtp_SendInfoToAdmin(spools(p,"ROSTER contacts - Cannot save contacts-letter file ",lcFrom,".",p ),SMTP_SITA_P);
      }


   // free old data 
   PM_SetItemTmpEx(6120,loItem->p,xmlnode_pool(loOnI),1);
   xmlnode_free(loOnI);

   pool_free(p);
   return;
   }

xmlnode SMTP_PieceSettings(char *lcFrom , char *lcTo, int *liType)
   {
   xmlnode loJIDd,loJIDa,loJIDs,loJIDc,loJID;
   loJIDd=xmlnode_get_tag(jtin->config,"jabber/defaultaccount"); // get default account
   loJIDs=xmlnode_get_tag(jtin->config,"smtp/defaultaccount"); // get default account
   loJIDa=SMTP_GetItemRoster(lcFrom,0); // get account
   loJIDc=smtp_online_get_item(lcFrom,lcTo,0); // get contact account

   // now test what settings use
   if (j_atoi(xmlnode_get_attrib(loJIDa,"UseGlobalSettings"),1)==0) // don't use global settings
      if (loJIDc!=NULL && j_atoi(xmlnode_get_attrib(loJIDc,"UseAccountSettings"),1)==0) // don't use account settings
         {
         loJID=xmlnode_dup(loJIDc);
         xmlnode_insert_tag_node(loJID,xmlnode_get_tag(loJIDa,"graylist"));
         *liType=SMTP_SETTINGS_CONTACT;
         }
      else   
         {
         loJID=xmlnode_dup(loJIDa);
         *liType=SMTP_SETTINGS_ACCOUNT;
         }
   else
      {
      loJID=xmlnode_dup(loJIDd);
      // proved kopii obsahu (atributy) loJIDs to loJID
      xmlnode_insert_node(loJID,xmlnode_get_firstattrib(loJIDs));
      xmlnode_insert_tag_node(loJID,xmlnode_get_tag(loJIDa,"graylist"));
      *liType=SMTP_SETTINGS_DEFAULT;
      }

   xmlnode_free(loJIDa);
   xmlnode_free(loJIDc);
   return loJID;
   }
