/* --------------------------------------------------------------------------
 *
 * License
 *
 * The contents of this file are subject to the Jabber Open Source License
 * Version 1.0 (the "License").  You may not copy or use this file, in either
 * source code or executable form, except in compliance with the License.  You
 * may obtain a copy of the License at http://www.jabber.com/license/ or at
 * http://www.opensource.org/.  
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyrights
 * 
 * Portions created by or assigned to Jabber.com, Inc. are 
 * Copyright (c) 1999-2000 Jabber.com, Inc.  All Rights Reserved.  Contact
 * information for Jabber.com, Inc. is available at http://www.jabber.com/.
 *
 * Portions Copyright (c) 1998-1999 Jeremie Miller.
 *
 * Portions Copyright (c) 2002 Matthias Wimmer.
 * 
 * Portions Copyright (c) 2006 Martina Jindru.
 * 
 * Acknowledgements
 * 
 * Special thanks to the Jabber Open Source Contributors for their
 * suggestions and support of Jabber.
 * 
 * --------------------------------------------------------------------------*/
 
#include "smtp.h"

smtpi  jtin;
/*

This is the smtp server component.

It acts as a simple SMTP server for both receiving email directly from another server or for delivering
email to another server.

What inspired me to write this very frightening thing is a mystery :) 

Jer

*/


result smtp_test(void *arg)
   {
/*
   xmlnode jep0033,cur,loResult;
   cur = xmlnode_get_tag(jtin->config,"core/map");
   jep0033= xmlnode_new_tag("iq");
   xmlnode_put_attrib(jep0033,"to",xmlnode_get_attrib(cur, "jabber"));
   xmlnode_put_attrib(jep0033,"from",jtin->met);
   xmlnode_put_attrib(jep0033,"type","get");
   xmlnode_put_attrib(jep0033,"id","smtp_test_jep0033");
   xmlnode_put_attrib(xmlnode_insert_tag(jep0033,"query"),"xmlns","http://jabber.org/protocol/disco#info");
//   HJPM_Reg("smtp_test_jep0033",(void*) smtp_out_packets_iq_xep0033,NULL,NULL);
//   deliver(dpacket_new(xmlnode_dup(jep0033)),jtin->i);

   SMTPx_DEBUG(SMTP_ZONE,"BEFORE delivery modal packet");
   loResult=DM_deliver(jep0033);
   SMTPx_DEBUG(SMTP_ZONE,"AFTER delivery modal packet %s",xmlnode2str(loResult));
   
   xmlnode_free(jep0033);
   xmlnode_free(loResult);
*/

//SMTPx_DEBUG(SMTP_ZONE,"BEFORE delivery modal packet gorila %i",smtp_ispaid("gorila@localhost",NULL));
//SMTPx_DEBUG(SMTP_ZONE,"BEFORE delivery modal packet foxbot %i",smtp_ispaid("foxbot@localhost",NULL));


   return r_DONE;
   }

/* takes foo@mapped.host or foo%jabber.org@smtp.host and translates to foo@jabber.org */
jid smtp_mx2( jid id)
   {
   char *at, *trhost,*lcJID,*lcVIP;
   xmlnode tr;
   int liVIP=0,liFound;

   if(id == NULL || id->user == NULL) return NULL;

   log_notice(ZONE,"mx2 checking %s",jid_full(id));

   // query for any translation
   if ((at = strstr(id->user,"%")) != NULL)
      {
      *at = '@';
      id = jid_new(id->p,id->user);
      lcJID=jid_full(id);

      // check to make sure this id is valid to relay between 
      if (id != NULL && jtin->SMTP_Open == 0 && 
          smtp_check_list(lcJID,xmlnode_get_tag(jtin->config,"smtp/opens/item"),&liFound)!=1
          )
         {
         // test na VIP
         lcVIP=xmlnode_get_tag_data(jtin->config,"smtp/vip");
         if (lcVIP!=NULL && *lcVIP=='1') // VIP test
            liVIP=smtp_ispaid(lcJID,NULL);

         if (liVIP==0)
            return NULL;
         }
      }
   else
      {
      tr = xmlnode_get_tag(jtin->config, spools(id->p, "core/map?mxhost=",id->server,id->p));
      trhost = xmlnode_get_attrib(tr,"jabber");

      if (trhost == NULL)
         return NULL;

      jid_set(id,trhost,JID_SERVER);
      }

   log_notice(ZONE,"mx2 returning %s",jid_full(id));
   return id;
   }

/* takes foo@jabber.org and translates to foo@mapped.host or foo%jabber.org@smtp.host */
jid smtp_2mx( jid from)
   {
   char *at, *trhost, *strid,*lcJID,*lcVIP;
   jid id;
   xmlnode tr;
   int liVIP=1,liFound;

   if(from == NULL || from->user == NULL) return NULL;

   log_debug(ZONE,"2mx checking %s",jid_full(from));

   /* copy jid and modify copy for the result */
   id = jid_new(from->p,jid_full(from));
   jid_set(id,NULL,JID_RESOURCE);


   /* query for any translation */
   tr = xmlnode_get_tag(jtin->config, spools(id->p, "core/map?jabber=",id->server,id->p));

   trhost = xmlnode_get_attrib(tr,"mxhost");
   
   if (trhost != NULL)
      jid_set(id,trhost,JID_SERVER);
   else
      {
      lcJID=jid_full(id);
      // check to make sure this id is valid to relay between 
      if (id != NULL && jtin->Jabber_Open == 0 && 
          smtp_check_list(lcJID,xmlnode_get_tag(jtin->config,"jabber/opens/item"),&liFound)!=1
         )
         {
         // test na VIP...
         lcVIP=xmlnode_get_tag_data(jtin->config,"jabber/vip");
         if (lcVIP!=NULL && *lcVIP=='1') // VIP test
            liVIP=smtp_ispaid(lcJID,NULL);

         if (liVIP==0)
            return NULL;
         }

      strid = jid_full(id);
      at = strstr(strid,"@");
      *at = '%';
      id = jid_new(id->p,jtin->me);
      jid_set(id,strid,JID_USER);
      }

   log_debug(ZONE,"2mx returning %s",jid_full(id));
   return id;
   }

void smtp_SendInfoToAny(const char *lcFrom,const char *lcTo, const char *lcMSG,int liType, xmlnode loError)
   {
   xmlnode loMSG;
   if (liType==SMTP_SITA_N)
      return;

   if (liType==SMTP_SITA_P)
      loMSG= xmlnode_new_tag("presence");
   else
      loMSG= xmlnode_new_tag("message");

   PM_Reg(3021, NULL,xmlnode_pool(loMSG),1,NULL);
   if (j_strlen(lcFrom)>0)
      xmlnode_put_attrib(loMSG,"from",lcFrom);
   else
      xmlnode_put_attrib(loMSG,"from",jtin->met);

   if (liType==SMTP_SITA_P)
      {
      xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"show"),"chat",-1);
      if (loError)
         xmlnode_insert_tag_node(loMSG,loError);
      else
         xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"status"),lcMSG,-1);
      }
   else
      {
      if (liType==SMTP_SITA_C)
         xmlnode_put_attrib(loMSG,"type","chat");
      xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"body"),lcMSG,-1);
      }

   xmlnode_put_attrib(loMSG,"to",lcTo);
   deliver(dpacket_new(xmlnode_dup(loMSG)),jtin->i);
   smtp_stats_out(loMSG);

   xmlnode_free(loMSG);
   }

void smtp_SendInfoToAdmin(const char *lcMSG,int liType)
   {
   xmlnode loMSG,loAdmin;
   if (liType==SMTP_SITA_P)
      loMSG= xmlnode_new_tag("presence");
   else
      loMSG= xmlnode_new_tag("message");

   PM_Reg(3020, NULL,xmlnode_pool(loMSG),1,NULL);

   xmlnode_put_attrib(loMSG,"from",jtin->met);

   if (liType==SMTP_SITA_P)
      {
      xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"show"),"chat",-1);
      xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"status"),lcMSG,-1);
      }
   else
      {
      xmlnode_put_attrib(loMSG,"type","chat");
      xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"body"),lcMSG,-1);
      }

   for (loAdmin = xmlnode_get_firstchild(xmlnode_get_tag(jtin->config,"core/admins")); loAdmin != NULL; loAdmin = xmlnode_get_nextsibling(loAdmin))
       {
       if (loAdmin->type!=NTYPE_TAG || strcmp(xmlnode_get_attrib(loAdmin,"xmlns"),"smtp:admin:info_track")!=0 )
	       	    continue;

       xmlnode_put_attrib(loMSG,"to",xmlnode_get_data(loAdmin));
       deliver(dpacket_new(xmlnode_dup(loMSG)),jtin->i);
       smtp_stats_out(loMSG);
       }

   xmlnode_free(loMSG);
   }


result smtp_memtest(void *arg)
   {
   pool p=pool_new();
   char *lcPom=(char*) pmalloc_x(p, 4,' ');
   *(lcPom+3)='\0';
   
   if (jtin->memtest==NULL)
      jtin->memtest=xmlnode_new_tag_pool(jtin->i->p,"test");

   xmlnode_put_attrib(jtin->memtest,"test",lcPom);
log_notice("smtp","========= MEMTEST");

   return r_DONE;
   }

/*
void test2(smtp_pools *c)
   {
   smtp_pools b;
   pool p;

   b=pmalloco(p=pool_new(), sizeof(_smtp_pools));
   b->p=p; 
   b->index=2;

   *c=b;
   }


void test1(smtp_pools *a,smtp_pools *c)
   {
   smtp_pools b;
   pool p;

   b=pmalloco(p=pool_new(), sizeof(_smtp_pools));
   b->p=p; 
   b->index=1;
   *a=b;
   test2(c);
   }
*/

void smpt_PMI_cb(void *arg1)
   {
   smtp_SendInfoToAdmin((char*) arg1,SMTP_SITA_M);
   }


void smtp(instance i, xmlnode x)
   {
   xmlnode config,configF, cur, jep0033, loRF,loBackup,loOffline;
   xdbcache xc;
   char *lcPom,*lcFile;
   int liErr,lii,liFolderC;
   struct dirent *dirp, *dirpA;
   DIR      *dp,*dpA;
   pool p;
   spool lcSP;

/*
   SMTPx_DEBUG(SMTP_ZONE,"TEST OF FILLING struc");
   smtp_pools a1,c1;
   test1(&a1,&c1);
   SMTPx_DEBUG(SMTP_ZONE,"TEST OF struc a1 %i, %i",(int)a1->p,a1->index);
   SMTPx_DEBUG(SMTP_ZONE,"TEST OF struc c1 %i, %i",(int)c1->p,c1->index);
*/

   log_debug(ZONE,"SMTP transport loading");
   xc = xdb_cache(i);
   config = xdb_get(xc, jid_new(xmlnode_pool(x),"config@-internal"),"jabber:config:smtp");

   jtin = pmalloco(i->p,sizeof(_smtpi));
   jtin->met = xmlnode_get_attrib(xmlnode_get_parent(x),"id");

   /* set up internal instance and hash tables */
   jtin->i = i;
   jtin->xc = xc;
   jtin->jep0033= jtin->tmpBackupJabber=jtin->tmpBackupSMTP=
       jtin->tmpOfflineJabber=jtin->tmpOfflineSMTP=jtin->tmpCoreTmp=0;
   jtin->ContactList=NULL;
   jtin->memtest=NULL;
   jtin->pools=PM_InitRoot((void*)smpt_PMI_cb);
   jtin->hooks=HJPM_InitRoot((void*)smpt_PMI_cb);
   jtin->roster=NULL;

   p=pool_new();
   PM_Reg(3010,NULL, p,1,NULL);

   // get config file name and read it
   if ((jtin->config_file=xmlnode_get_tag_data(config,"config"))==NULL)
      jtin->config_file=pstrdup(i->p,SMTP_CONFIG_FILE);

   if ((configF=xmlnode_file(jtin->config_file))==NULL)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot load config file.");
      return;
      }
   jtin->config = xmlnode_dup_pool(i->p, configF);
   xmlnode_free(configF);


   // get config runtime file name and read it
   if ((jtin->configr_file=xmlnode_get_tag_data(jtin->config,"core/configr"))==NULL)
      jtin->configr_file=pstrdup(i->p,SMTP_CONFIGR_FILE);

   if ((configF=xmlnode_file(jtin->configr_file))==NULL)
      { // file not exist or any other bug, create new xmlnode
      log_warn("smtp","Transport cannot load config runtime file (%s).",jtin->configr_file);
      smtp_SendInfoToAdmin(spools(p, "Transport cannot load config runtime file (",jtin->configr_file,").",p),SMTP_SITA_P );

      jtin->configr = xmlnode_new_tag("service");
      xmlnode_put_attrib(xmlnode_insert_tag(jtin->configr,"smtp"),"state","1");
      xmlnode_put_attrib(xmlnode_insert_tag(jtin->configr,"jabber"),"state","1");
      xmlnode_insert_tag(jtin->configr,"core");
      }
    else
      jtin->configr = configF;

   PM_Reg(3030,NULL, xmlnode_pool(jtin->configr),0,(void*)jtin->configr);

   // try create backup folder
   loBackup=xmlnode_get_tag(jtin->config,"jabber/backup");
   if ((jtin->jabber_backup=xmlnode_get_attrib(loBackup,"folder")   )==NULL)
      jtin->jabber_backup= pstrdup(i->p,SMTP_BACKUPJABBER_FOLDER);

   if (smtp_CreateFolder(jtin->jabber_backup)==0 &&
       (liFolderC=smtp_CreateFolder(spools(p,jtin->jabber_backup,"/old",p)))==0)
      jtin->tmpBackupJabber=1;


   // test if any file in folder, if yes, send mesage to all admins
   if (jtin->tmpBackupJabber==1 && (dp = opendir(jtin->jabber_backup))!=NULL)
      {
      lii=0;
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "old") == 0)
               continue;      // ignore dot and dot-dot 

            rename(spools(p,jtin->jabber_backup,"/",dirp->d_name,p),spools(p,jtin->jabber_backup,"/old/",dirp->d_name,p));

            lii++;
            }
      closedir((DIR *)dp);

      if (lii>0)
         smtp_SendInfoToAdmin(spools(p,"Any jabber message (",smtp_itoa(p,lii),") cause reboot.",p),SMTP_SITA_M );
      }


   loBackup=xmlnode_get_tag(jtin->config,"smtp/backup");
   if ((jtin->smtp_backup=xmlnode_get_attrib(loBackup,"folder") )==NULL)
      jtin->smtp_backup= pstrdup(i->p,SMTP_BACKUPSMTP_FOLDER);


   if (smtp_CreateFolder(jtin->smtp_backup)==0 &&
       (liFolderC=smtp_CreateFolder(spools(p,jtin->smtp_backup,"/old",p)))==0)
      jtin->tmpBackupSMTP=1;

   // test if any file in folder, if yes, send mesage to all admins
   if (jtin->tmpBackupSMTP==1 && (dp = opendir(jtin->smtp_backup)) != NULL)
      {
      lii=0;
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "old") == 0)
               continue;      // ignore dot and dot-dot

            rename(spools(p,jtin->smtp_backup,"/",dirp->d_name,p),spools(p,jtin->smtp_backup,"/old/",dirp->d_name,p));

            lii++;
            }
      closedir((DIR *)dp);

      if (lii>0)
         smtp_SendInfoToAdmin(spools(p,"Any SMTP message (",smtp_itoa(p,lii),") cause reboot.",p),SMTP_SITA_M);
      }



   // try create offline folder - jabber
   loOffline=xmlnode_get_tag(jtin->config,"jabber/offline");
   if ((jtin->jabber_offline=xmlnode_get_attrib(loOffline,"folder"))==NULL)
      jtin->jabber_offline= pstrdup(i->p,SMTP_OFFLINEJABBER_FOLDER);

   if (smtp_CreateFolder(jtin->jabber_offline)==0)
      jtin->tmpOfflineJabber=1;


   // try create offline folder - smtp
   loOffline=xmlnode_get_tag(jtin->config,"smtp/offline");
   if ((jtin->smtp_offline=xmlnode_get_attrib(loOffline,"folder"))==NULL)
      jtin->smtp_offline= pstrdup(i->p,SMTP_OFFLINESMTP_FOLDER);

   if (smtp_CreateFolder(jtin->smtp_offline)==0)
      jtin->tmpOfflineSMTP=1;


   // try create tmp folder - core
   jtin->core_tmp= pstrdup(i->p,SMTP_CORETMP_FOLDER);
   if (smtp_CreateFolder(jtin->core_tmp)==0)
      jtin->tmpCoreTmp=1;


   // get default language
   if ((lcPom=xmlnode_get_tag_data(jtin->config,"core/language"))==NULL)
      lcPom= SMTP_RC_DEFAULT_LANG;

   jtin->DefaultLang=pstrdup(i->p, lcPom);

   // get statistics file name and read it
   if ((jtin->stat_file=xmlnode_get_tag_data(jtin->config,"core/statistics"))==NULL)
      jtin->stat_file=pstrdup(i->p, SMTP_STATISTICS_FILE);

   lcPom = (char*)pstrdup(p,jtin->stat_file);
   smtp_GetFolderFromFile(lcPom);
   liErr=smtp_CreateFolder(lcPom);


   if (liErr!=0)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot create folder for statistics file");
      return;
      }

   // Create statistics structure
   jtin->Stats=(smtp_stats) pmalloco(jtin->i->p, sizeof(_smtp_stats));
   jtin->Stats->StartLastDatetime = (char*) pmalloc_x(jtin->i->p, 18,' ');

   // Fill it from XML File
   if ((cur=xmlnode_file(jtin->stat_file))==NULL)
      { // file not exist or any other bug
      log_warn("smtp","Transport cannot load statistics file (%s).",jtin->stat_file);
      smtp_SendInfoToAdmin(spools(p, "Transport cannot load statistics file (",jtin->stat_file,").",p),SMTP_SITA_P );

      jtin->Stats->Start=0;

	  jtin->Stats->_JabberMessages=0;
      jtin->Stats->_JabberMessagesOut=0;
      jtin->Stats->_JabberMessagesOutError=0;

      jtin->Stats->_SMTPCommandUnknown=0;
      jtin->Stats->_SMTPMessages=0;
      jtin->Stats->_SMTPProcessed=0;
      jtin->Stats->_SMTPNRRecipient=0;
      jtin->Stats->_SMTPBadRecipient=0;

      jtin->Stats->_SMTPSpam=0;
      jtin->Stats->_SMTPMaxSize=0;
      jtin->Stats->_SMTPNoProcess=0;

      jtin->Stats->_SMTPBouncy=0;
      jtin->Stats->_SMTPNoRecipient=0;
      jtin->Stats->_SMTPSpammers=0;
      jtin->Stats->_SMTPBlockedByRecipient=0;

      jtin->Stats->_XMPPInAll=0;
      jtin->Stats->_XMPPInMessage=0;
      jtin->Stats->_XMPPInPresence=0;
      jtin->Stats->_XMPPInSN10=0;
      jtin->Stats->_XMPPInIQ=0;
      jtin->Stats->_XMPPInUnknown=0;

      jtin->Stats->_XMPPOutAll=0;
      jtin->Stats->_XMPPOutMessage=0;
      jtin->Stats->_XMPPOutPresence=0;
      jtin->Stats->_XMPPOutSN10=0;
      jtin->Stats->_XMPPOutIQ=0;
      jtin->Stats->_XMPPOutUnknown=0;

      }  
   else
      {
      // Fill it from XML File
      jtin->Stats->Start=j_atoi(xmlnode_get_attrib(cur,"Start"),0);

	  jtin->Stats->_JabberMessages=j_atoi(xmlnode_get_attrib(cur,"JabberMessages"),0);
      jtin->Stats->_JabberMessagesOut=j_atoi(xmlnode_get_attrib(cur,"JabberMessagesOut"),0);
      jtin->Stats->_JabberMessagesOutError=j_atoi(xmlnode_get_attrib(cur,"JabberMessagesOutError"),0);

      jtin->Stats->_SMTPCommandUnknown=j_atoi(xmlnode_get_attrib(cur,"SMTPCommandUnknown"),0);
      jtin->Stats->_SMTPMessages=j_atoi(xmlnode_get_attrib(cur,"SMTPMessages"),0);
      jtin->Stats->_SMTPProcessed=j_atoi(xmlnode_get_attrib(cur,"SMTPProcessed"),0);
      jtin->Stats->_SMTPNRRecipient=j_atoi(xmlnode_get_attrib(cur,"SMTPNRRecipient"),0);
      jtin->Stats->_SMTPNRRecipient=j_atoi(xmlnode_get_attrib(cur,"SMTPBadRecipient"),0);

      jtin->Stats->_SMTPSpam=j_atoi(xmlnode_get_attrib(cur,"SMTPSpam"),0);

      jtin->Stats->_SMTPMaxSize=j_atoi(xmlnode_get_attrib(cur,"SMTPMaxSize"),0);
      jtin->Stats->_SMTPNoProcess=j_atoi(xmlnode_get_attrib(cur,"SMTPNoProcess"),0);

      jtin->Stats->_SMTPBouncy=j_atoi(xmlnode_get_attrib(cur,"SMTPBouncy"),0);
      jtin->Stats->_SMTPNoRecipient=j_atoi(xmlnode_get_attrib(cur,"SMTPNoRecipient"),0);
      jtin->Stats->_SMTPSpammers=j_atoi(xmlnode_get_attrib(cur,"SMTPSpammers"),0);
      jtin->Stats->_SMTPBlockedByRecipient=j_atoi(xmlnode_get_attrib(cur,"SMTPBlockedByRecipient"),0);

      jtin->Stats->_XMPPInAll=j_atoi(xmlnode_get_attrib(cur,"XMPPInAll"),0);
      jtin->Stats->_XMPPInMessage=j_atoi(xmlnode_get_attrib(cur,"XMPPInMessage"),0);
      jtin->Stats->_XMPPInPresence=j_atoi(xmlnode_get_attrib(cur,"XMPPInPresence"),0);
      jtin->Stats->_XMPPInSN10=j_atoi(xmlnode_get_attrib(cur,"XMPPInSN10"),0);
      jtin->Stats->_XMPPInIQ=j_atoi(xmlnode_get_attrib(cur,"XMPPInIQ"),0);
      jtin->Stats->_XMPPInUnknown=j_atoi(xmlnode_get_attrib(cur,"XMPPInUnknown"),0);

      jtin->Stats->_XMPPOutAll=j_atoi(xmlnode_get_attrib(cur,"XMPPOutAll"),0);
      jtin->Stats->_XMPPOutMessage=j_atoi(xmlnode_get_attrib(cur,"XMPPOutMessage"),0);
      jtin->Stats->_XMPPOutPresence=j_atoi(xmlnode_get_attrib(cur,"XMPPOutPresence"),0);
      jtin->Stats->_XMPPOutSN10=j_atoi(xmlnode_get_attrib(cur,"XMPPOutSN10"),0);
      jtin->Stats->_XMPPOutIQ=j_atoi(xmlnode_get_attrib(cur,"XMPPOutIQ"),0);
      jtin->Stats->_XMPPOutUnknown=j_atoi(xmlnode_get_attrib(cur,"XMPPOutUnknown"),0);

      xmlnode_free(cur);
      }
   

   jtin->Stats->_CoreContacts=0;
   jtin->Stats->_CoreAccounts=0;
   
   jtin->Stats->JabberMessages=jtin->Stats->JabberMessagesOut=jtin->Stats->JabberMessagesOutError=
      jtin->Stats->SMTPCommandUnknown=jtin->Stats->SMTPMessages=
      jtin->Stats->SMTPProcessed=jtin->Stats->SMTPNRRecipient=jtin->Stats->SMTPBadRecipient=
      jtin->Stats->SMTPSpam=jtin->Stats->CoreAccounts=jtin->Stats->SMTPMaxSize=
      jtin->Stats->SMTPNoProcess=jtin->Stats->SMTPBouncy=jtin->Stats->SMTPNoRecipient=
      jtin->Stats->SMTPBlockedByRecipient=
      jtin->Stats->XMPPInAll=jtin->Stats->XMPPInMessage=jtin->Stats->XMPPInPresence=
      jtin->Stats->XMPPInSN10=jtin->Stats->XMPPInIQ=jtin->Stats->XMPPInUnknown=
      jtin->Stats->XMPPOutAll=jtin->Stats->XMPPOutMessage=jtin->Stats->XMPPOutPresence=
      jtin->Stats->XMPPOutSN10=jtin->Stats->XMPPOutIQ=jtin->Stats->XMPPOutUnknown=0;


   // get resources file name and read it
   if ((jtin->res_file=xmlnode_get_tag_data(jtin->config,"core/resources"))==NULL)
      jtin->res_file=pstrdup(i->p,SMTP_RESOURCE_FILE);

   if ((jtin->resources=xmlnode_file(jtin->res_file))==NULL)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot load resource file (%s).",jtin->res_file);
      return;
      }

   PM_Reg(3040, NULL,xmlnode_pool(jtin->resources),0,(void*) jtin->resources);

   // Get jabstatus folder
   if ((jtin->jabstats_folder=xmlnode_get_tag_data(jtin->config,"core/jabstats"))==NULL)
      jtin->jabstats_folder=pstrdup(i->p,SMTP_JABSTATS_FOLDER);
   jtin->jabstats=NULL;
   smtp_CreateFolder(jtin->jabstats_folder);


   // get roster folder
   // test if exist, if not exist, create it
   if ((jtin->roster_folder=xmlnode_get_tag_data(jtin->config,"core/roster"))==NULL)
      jtin->roster_folder=pstrdup(i->p,SMTP_ROSTER_FOLDER);

   liErr=smtp_CreateFolder(jtin->roster_folder);
   if (liErr!=0)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot create folder (%s) for roster files.",jtin->roster_folder);
      return;
      }

   liErr=smtp_CreateFolder(spools(p,jtin->roster_folder,"/backup",p));
   if (liErr!=0)
      { // cannot create folder or any other bug
      log_error("smtp","Transport cannot create folder (%s) for roster.",spools(p,jtin->roster_folder,"/backup",p));
      return;
      }


   // Read roster files ?????????.ri.xml from roster folder
   if ((dp = opendir(jtin->roster_folder))!=NULL)
      {
      lcSP=spool_new(p);
      lii=0;
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "backup") == 0)
               continue;      // ignore dot and dot-dot or backup folder


            if ((dpA = opendir(spools(p,jtin->roster_folder,"/",dirp->d_name,p)))!=NULL)
               {
               while ( (dirpA = readdir((DIR *)dpA)) != NULL)
                     {
                     if (strcmp(dirpA->d_name, ".") == 0  ||
                         strcmp(dirpA->d_name, "..") == 0)
                        continue;      // ignore dot and dot-dot

                     if (strstr(dirpA->d_name,".ai.xml")!=NULL)
                        {
                        // read file as XMLNODE
                        lcFile=spools(p,jtin->roster_folder,"/",dirp->d_name,"/",dirpA->d_name,p);
                        if ((loRF=xmlnode_file(lcFile))==NULL)
                           {
                           log_warn("smtp","Transport cannot read roster file %s",lcFile);
                           spooler(lcSP, "Transport cannot read roster file ",lcFile,".\r\n",lcSP);
                           rename(lcFile,spools(p,jtin->roster_folder,"/backup/",dirpA->d_name,p));
                           lii++;
                           }
                        else
                           {               
                           // Add item do roster
                           SMTP_SetItemRoster(loRF,0);
                           xmlnode_free(loRF);
                           }
                        continue;
                        }

                     if (strstr(dirpA->d_name,".cl.xml")!=NULL)
                        {
                        // try read file with contacts
                        // if reading failed, then copy it to backup folder
                        //  and send info to admin
                        lcFile=spools(p,jtin->roster_folder,"/",dirp->d_name,"/",dirpA->d_name,p);
                        if ((cur=xmlnode_file(lcFile))==NULL)
                           {
                           log_warn("smtp","Transport cannot load contact file (%s)", lcFile);
                           spooler(lcSP, "Transport cannot load contact file ",lcFile,".\r\n",lcSP);
                           rename(lcFile,spools(p,jtin->roster_folder,"/backup/",dirpA->d_name,p));
                           lii++;
                           }
                        else
                           {
                           smtp_cjidAppend(smtp_cjidNew(cur,NULL));
                           xmlnode_free(cur);
                           }
                        continue;
                        }
                     }
               closedir((DIR *)dpA);
               if (lii>0)
                  smtp_SendInfoToAdmin(spool_print(lcSP),SMTP_SITA_M );

               }
            else
               {
               log_error("smtp","Transport cannot open folder (%s) (roster).",spools(p,jtin->roster_folder,"/",dirp->d_name,p));
               return;
               }
            }
      closedir((DIR *)dp);
      }
   else
      { // cannot create folder or any other bug
      log_error("smtp","Transport cannot open folder (%s) (roster).",jtin->roster_folder);
      return;
      }


   // recalc user's accounts by saved files
   jtin->Stats->_CoreAccounts=SMTP_GetItemCountRoster(SMTP_ACCOUNT_ALL);

   // main body
   if ((jtin->me = xmlnode_get_tag_data(jtin->config,"jabber/mxhost")) == NULL)
      {
      log_error("smtp","Transport must have a default SMTP <mxhost>smtp.host.foo</mxhost> configured");
      return;
      }


   lcPom=xmlnode_get_tag_data(jtin->config,"smtp/maxsize");
   if (j_strlen(lcPom)==0)
      jtin->iMaxSize=SMTP_DATA_MAX;
   else
      jtin->iMaxSize=j_atoi(lcPom,0);

   lcPom=xmlnode_get_tag_data(jtin->config,"smtp/fastprocessingbuffersize");
   if (j_strlen(lcPom)==0)
      jtin->iFastProcessingBufferSize=SMTP_FAST_PROCESSING_BUFFER_SIZE;
   else
      jtin->iFastProcessingBufferSize=j_atoi(lcPom,0);


   if (xmlnode_get_tag(jtin->config,"smtp/opens") == NULL)
      jtin->SMTP_Open = 1;

   if (xmlnode_get_tag(jtin->config,"jabber/opens") == NULL)
      jtin->Jabber_Open = 1;

   if (xmlnode_get_tag(jtin->config,"smtp/spamer") == NULL)
      jtin->Spamer_Open = 1;

   // relay smtp server
   cur = xmlnode_get_tag(jtin->config,"jabber/relay");
   jtin->relayport=j_atoi(xmlnode_get_attrib(cur, "port"), SMTP_Relay_Port);

   if((jtin->relay = xmlnode_get_attrib(cur,"ip")) == NULL)
       jtin->relay = pstrdup(i->p, SMTP_DEFAULT_RELAY);

   register_phandler(i, o_DELIVER, smtp_out_packets, (void *)jtin);


   jtin->spamcheck = xmlnode_get_tag_data(jtin->config,"smtp/spamcheck");

   if ( (cur=xmlnode_get_tag(jtin->config,"smtp/timeout"))!=NULL)
      jtin->timeout = j_atoi(xmlnode_get_attrib(cur,"interval"),SMTP_TimeOut);
   else
      jtin->timeout=SMTP_TimeOut;


   // vytvoit vlastn thread
   if ((cur = xmlnode_get_tag(config,"smtp/ip")) != NULL)
      for (;cur != NULL; xmlnode_hide(cur), cur = xmlnode_get_tag(config,"smtp/ip"))
          {
          mio_listen(j_atoi(xmlnode_get_attrib(cur, "port"), SMTP_Incomming_Port), xmlnode_get_data(cur), smtp_in_read, (void*)NULL, NULL, NULL);
          }
   else // no special config, use defaults //
      mio_listen(SMTP_Incomming_Port, NULL, smtp_in_read, (void *)NULL, NULL, NULL);
 
   if ((cur=xmlnode_get_tag(jtin->config,"jabber/offline"))!=NULL)
      register_beat(j_atoi(xmlnode_get_attrib(cur,"interval"),1)*60 , smtp_offline_jdaemon, (void *) 1);


   if ((cur=xmlnode_get_tag(jtin->config,"smtp/offline"))!=NULL)
      register_beat(j_atoi(xmlnode_get_attrib(cur,"interval"),1)*60 , smtp_offline_sdaemon, (void *) 1);

   if ((cur=xmlnode_get_tag(jtin->config,"core/vip"))!=NULL)
      register_beat(j_atoi(xmlnode_get_attrib(cur,"interval"),1)*60 , smtp_paid_daemon, (void *)jtin);

   register_beat(jtin->timeout , smtp_in_daemon, (void *)NULL);

   // initalize pool manager daemon for checking which pools are lost
   PM_InitDaemon();
   HJPM_InitDaemon();

   jtin->Stats->Start++;
   jtin->Stats->StartLastDatetime=smtp_GetDateTime(jtin->Stats->StartLastDatetime);
   smtp_StatsSave();

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"Transport loaded - %s (%s).",jtin->Stats->StartLastDatetime,smtp_version);
   #endif
   smtp_SendInfoToAdmin(spools(p, "Transport loaded - ",jtin->Stats->StartLastDatetime," (",smtp_version,")",".",p),SMTP_SITA_M);

/*
   SMTPx_DEBUG(SMTP_ZONE,"SPAMER TEST START");
   lii=0;
   SMTPx_DEBUG(SMTP_ZONE,"SPAMER - %s %i","jindra@egservis.cz",smtp_check_list("jindra@egservis.cz",xmlnode_get_tag(jtin->config,"smtp/spamer/item"),&lii));
   lii=0;
   SMTPx_DEBUG(SMTP_ZONE,"SPAMER - %s %i","martin.jindra@egservis.cz",smtp_check_list("martin.jindra@egservis.cz",xmlnode_get_tag(jtin->config,"smtp/spamer/item"),&lii));
   lii=0;
   SMTPx_DEBUG(SMTP_ZONE,"SPAMER - %s %i","tucek@egservis.cz",smtp_check_list("tucek@egservis.cz",xmlnode_get_tag(jtin->config,"smtp/spamer/item"),&lii));
   lii=0;
   SMTPx_DEBUG(SMTP_ZONE,"SPAMER - %s %i","kiks@seznam.cz",smtp_check_list("kiks@seznam.cz",xmlnode_get_tag(jtin->config,"smtp/spamer/item"),&lii));
*/  

   // JEP-0033 test
   cur = xmlnode_get_tag(jtin->config,"core/map");
   jep0033= xmlnode_new_tag_pool(p,"iq");
   xmlnode_put_attrib(jep0033,"to",xmlnode_get_attrib(cur, "jabber"));
   xmlnode_put_attrib(jep0033,"from",jtin->met);
   xmlnode_put_attrib(jep0033,"type","get");
   xmlnode_put_attrib(jep0033,"id","smtp_test_jep0033");
   xmlnode_put_attrib(xmlnode_insert_tag(jep0033,"query"),"xmlns","http://jabber.org/protocol/disco#info");
   HJPM_Reg("smtp_test_jep0033",(void*) smtp_out_packets_iq_xep0033,NULL,NULL);
   deliver(dpacket_new(xmlnode_dup(jep0033)),i);
   smtp_stats_out(jep0033);

//   register_beat(30 , smtp_test, (void *)NULL);

   pool_free(p); 
   }


void smtp_StatsSave()
   {
   xmlnode loStats;
   pth_mutex_t mutex = PTH_MUTEX_INIT;
   pth_mutex_acquire(&mutex, TRUE, NULL);

   loStats=xmlnode_new_tag("smtp");
   pool p=xmlnode_pool(loStats);
   PM_Reg(3050, NULL,p,1,NULL);

   xmlnode_put_attrib(loStats,"xmlns","jabber:status:smtp");

   xmlnode_put_attrib(loStats,"Start",smtp_itoa(p,jtin->Stats->Start));
   xmlnode_put_attrib(loStats,"StartLastDatetime",jtin->Stats->StartLastDatetime);

   xmlnode_put_attrib(loStats,"JabberMessages",smtp_itoa(p,jtin->Stats->_JabberMessages));
   xmlnode_put_attrib(loStats,"JabberMessagesOut",smtp_itoa(p,jtin->Stats->_JabberMessagesOut));
   xmlnode_put_attrib(loStats,"JabberMessagesOutError",smtp_itoa(p,jtin->Stats->_JabberMessagesOutError));

   xmlnode_put_attrib(loStats,"SMTPCommandUnknown",smtp_itoa(p,jtin->Stats->_SMTPCommandUnknown));
   xmlnode_put_attrib(loStats,"SMTPMessages",smtp_itoa(p,jtin->Stats->_SMTPMessages));
   xmlnode_put_attrib(loStats,"SMTPProcessed",smtp_itoa(p,jtin->Stats->_SMTPProcessed));
   xmlnode_put_attrib(loStats,"SMTPNRRecipient",smtp_itoa(p,jtin->Stats->_SMTPNRRecipient));
   xmlnode_put_attrib(loStats,"SMTPBadRecipient",smtp_itoa(p,jtin->Stats->_SMTPBadRecipient));

   xmlnode_put_attrib(loStats,"SMTPSpam",smtp_itoa(p,jtin->Stats->_SMTPSpam));
   xmlnode_put_attrib(loStats,"SMTPMaxSize",smtp_itoa(p,jtin->Stats->_SMTPMaxSize));
   xmlnode_put_attrib(loStats,"SMTPNoProcess",smtp_itoa(p,jtin->Stats->_SMTPNoProcess));

   xmlnode_put_attrib(loStats,"SMTPBouncy",smtp_itoa(p,jtin->Stats->_SMTPBouncy));
   xmlnode_put_attrib(loStats,"SMTPNoRecipient",smtp_itoa(p,jtin->Stats->_SMTPNoRecipient));
   xmlnode_put_attrib(loStats,"SMTPSpammers",smtp_itoa(p,jtin->Stats->_SMTPSpammers));
   xmlnode_put_attrib(loStats,"SMTPBlockedByRecipient",smtp_itoa(p,jtin->Stats->_SMTPBlockedByRecipient));

   xmlnode_put_attrib(loStats,"XMPPInAll",smtp_itoa(p,jtin->Stats->_XMPPInAll));
   xmlnode_put_attrib(loStats,"XMPPInMessage",smtp_itoa(p,jtin->Stats->_XMPPInMessage));
   xmlnode_put_attrib(loStats,"XMPPInPresence",smtp_itoa(p,jtin->Stats->_XMPPInPresence));
   xmlnode_put_attrib(loStats,"XMPPInSN10",smtp_itoa(p,jtin->Stats->_XMPPInSN10));
   xmlnode_put_attrib(loStats,"XMPPInIQ",smtp_itoa(p,jtin->Stats->_XMPPInIQ));
   xmlnode_put_attrib(loStats,"XMPPInUnknown",smtp_itoa(p,jtin->Stats->_XMPPInUnknown));

   xmlnode_put_attrib(loStats,"XMPPOutAll",smtp_itoa(p,jtin->Stats->_XMPPOutAll));
   xmlnode_put_attrib(loStats,"XMPPOutMessage",smtp_itoa(p,jtin->Stats->_XMPPOutMessage));
   xmlnode_put_attrib(loStats,"XMPPOutPresence",smtp_itoa(p,jtin->Stats->_XMPPOutPresence));
   xmlnode_put_attrib(loStats,"XMPPOutSN10",smtp_itoa(p,jtin->Stats->_XMPPOutSN10));
   xmlnode_put_attrib(loStats,"XMPPOutIQ",smtp_itoa(p,jtin->Stats->_XMPPOutIQ));
   xmlnode_put_attrib(loStats,"XMPPOutUnknown",smtp_itoa(p,jtin->Stats->_XMPPOutUnknown));

   xmlnode2file(jtin->stat_file,loStats);
   xmlnode_free(loStats);

   pth_mutex_release(&mutex);

   }


void smtp_ConfigSave()
   {
   xmlnode loConfigR;
   loConfigR=jtin->configr;
   jtin->configr=xmlnode_dup(loConfigR);
   xmlnode2file(jtin->configr_file,jtin->configr);
   PM_Reg(3030,NULL, xmlnode_pool(jtin->configr),0,(void*)jtin->configr);
   xmlnode_free(loConfigR);
   }


smtps smtp_new_out(mio m)
   {
   smtps so;

   so = pmalloco(mio_pool(m), sizeof(_smtps));
   so->m = m;
   so->p = mio_pool(m);
   so->x=so->oJID=so->oAD=NULL;
   so->jp=NULL;
   
   so->toPGPMIME=so->SRMode=0;
   so->SRSeparator=so->SRText=so->cStatus=NULL;
   return so;
   }

void smtp_reset_in(smtpsi si)
   {
   smptsi_rcp next;
   si->rcpt=si->rcptFD=(void*) NULL;
   si->iSize=si->iProcessMail=si->iEnd=si->iTimerS=si->iTimerN=si->iSizeMF=si->iDCRLF=si->iFastProcessing=si->iDOTAdd=0;
   si->oMsg=NULL;
   si->from=si->fromEx=si->buffer=si->host=si->listcc=si->listto=si->MBody=si->cStatus=NULL;

   if (si->x!=NULL)
      xmlnode_free(si->x);

   if (si->buffer!=NULL)
      free(si->buffer); // Free internal buffer

   if (si->pMessage!=NULL)
      pool_free(si->pMessage);

   next = (smptsi_rcp) si->rcpt;
   while(next != NULL)
        {
        xmlnode_free(next->oJID);
        next = next->next;
        }
   si->x = NULL;
   si->buffer=NULL;

   }

smtpsi smtp_new_in(pool p,mio m)
   {
   smtpsi si;
   si = pmalloco(p, sizeof(_smtpsi));
   smtp_reset_in(si);
   si->m = m;
   si->p = p;
   return si;
   }



smtpp smtp_param_i(pool p,instance i)
   {
   smtpp par;
   par=pmalloco(p, sizeof(_smtpp));
   par->tmppool=p;
   par->i = i;
   par->jp = NULL;
   par->lang=NULL;
   return par;
   }


smptsi_rcp smtp_NewRecipient(pool p,jid ojid)
   {
   smptsi_rcp rcp;

   rcp=pmalloco(p, sizeof(_smptsi_rcp));
   rcp->rcpt=ojid;
   rcp->next=NULL;
   rcp->iForwarde=rcp->_iForwarde=rcp->iSpammer=rcp->_iSpammer=rcp->_iGSpammer=0;
   return rcp;
   }

smptsi_rcp smtp_AppendRcpt(smptsi_rcp a, smptsi_rcp b)
   {
   smptsi_rcp next;

   if (a == NULL)
      return NULL;

   if (b == NULL)
      return a;

   next = a;
   while(next != NULL)
        {
        if (next->next != NULL)
           next = next->next;
        else
           {
           next->next = b;
           break;
           }
        }
   return a;
   }

void smtp_SetGSpammerRcpt(smptsi_rcp a)
   {
   smptsi_rcp next=a,loRoot=a;
   int liGSpammer=1;

   if (a == NULL)
      return ;

   while(next != NULL)
        {
        liGSpammer=((next->iSpammer==1) && (liGSpammer==1))?1:0;
        next = next->next;
        }
   loRoot->_iGSpammer=liGSpammer; //save global spammer statsus - for all recipient is spammer
   return ;
   }



smtp_jq smtp_NewQueueItem(pool p, int liType)
   {
   smtp_jq item;
   item=pmalloco(p, sizeof(_smtp_jq));
   switch (liType)
      {
	  case SMTP_QUEUE_X:
           item->Data=pmalloco(p, sizeof(_smtp_jq_x));
           break;

	  case SMTP_QUEUE_CB:
           item->Data=pmalloco(p, sizeof(_smtp_jq_cb));
           break;
      }

   item->iType=liType;
   item->next=NULL;
   return item;
   }


smtp_jq smtp_AppendQueueItem(smtp_jq a, smtp_jq b)
   {
   smtp_jq next=a;

   if (a == NULL)
      return NULL;

   if (b == NULL)
      return a;

   while(next != NULL)
        {
        if (next->next != NULL)
           next = next->next;
        else
           {
           next->next = b;
           break;
           }
        }
   return b;
   }





void smtp_FlushQueue(instance i, smtp_jq item)
   {
   smtp_jq next = item;
   smtp_jq_cb item_cb; 
   smtp_jq_x item_x; 

   while(next != NULL)
        {
        switch (next->iType)
           {
	       case SMTP_QUEUE_X:
                item_x= (smtp_jq_x) next->Data;
                deliver(dpacket_new(xmlnode_dup(item_x->x)),i);
                smtp_stats_out(item_x->x);
                xmlnode_free(item_x->x);
                break;

  	       case SMTP_QUEUE_CB:
                item_cb= (smtp_jq_cb) next->Data;
                (*(smtp_queue_cb)item_cb->cb)(item_cb->arg);
                break;
           }

        next = next->next;
        }
   }


void smtp_ClearQueue(smtp_jq item)
   {
   smtp_jq next = item;
   smtp_jq_x item_x; 

   while(next != NULL)
        {
        if (next->iType==SMTP_QUEUE_X && next->Data!=NULL)
           {
           item_x= (smtp_jq_x) next->Data;
           xmlnode_free(item_x->x);
           }

        next = next->next;
        }
   }



smtp_jcmdq smtp_CmdNew()
   {
   smtp_jcmdq item;
   pool p;
   item=pmalloco(p=pool_new(), sizeof(_smtp_jcmdq));
   PM_Reg(3070,NUL, p,1,NULL);

   item->p=p;
   item->next=NULL;
   item->iLevel=0;
   item->cSessionID=NULL;
   return item;
   }


smtp_jcmdq smtp_CmdAppend(smtp_jcmdq b)
   {
   smtp_jcmdq next=jtin->qcmd;

   if (b == NULL)
      return NULL;

   if (next == NULL)
      {
      jtin->qcmd=b;
      return b;
      }

   while(next != NULL)
        {
        if (next->next != NULL)
           next = next->next;
        else
           {
           next->next = b;
           break;
           }
        }
   return b;
   }

smtp_jcmdq smtp_CmdGet(char *lcSessionID)
   {
   smtp_jcmdq next=jtin->qcmd,b=NULL;
   if (lcSessionID==NULL)
      return NULL;

   while(next != NULL)
        {
        if (j_strcmp(next->cSessionID,lcSessionID)==0)
           {
           b=next;
           break;
           }

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return b;
   }

void smtp_CmdDel(char *lcSessionID)
   {
   smtp_jcmdq next=jtin->qcmd,prev=NULL;
   if (lcSessionID==NULL)
       return;

   while(next != NULL)
        {
        if (j_strcmp(next->cSessionID,lcSessionID)==0)
           {
           if (next==jtin->qcmd)
              jtin->qcmd=NULL;
           else
              prev->next=next->next;

           pool_free(next->p);
           break;
           }

        prev=next;
        if (next->next != NULL)
           next = next->next;
        else
           break;
        }
   return ;
   }

int smtp_CmdGetMem(int liType,char *lcSessionID)
   {
   smtp_jcmdq next=jtin->qcmd;
   int lii=0;

   while(next != NULL)
        {
        if (liType==SMTP_MEMORY_ALL || (liType==SMTP_MEMORY_JID && j_strcmp(next->cSessionID,lcSessionID)==0))
           lii+=pool_size(next->p);

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return lii;
   }
