#include <jabberd.h>

#include <time.h>
#include <stdio.h>
#include <math.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <dirent.h>

//#include <iconv.h> // http://mir.zyrianes.net/cygwin/release/libiconv/

#define smtp_version "0.6.0.000 (FE)"
#define smtp_name    "Jabber-SMTP-Transport (FE)"
#define smtp_contact "Jabber-SMTP-Contact (FE)"


#include "rc_strings.h"
#include "poolm.h"
#include "hookjpm.h"
#include "threads.h"
#include "libxg.h"
#include "deliverg.h"

#define MAXLOOP       100000
#define SMTP_DATA_MAX 100000
#define SMTP_FAST_PROCESSING_BUFFER_SIZE 1024

#define PHASE_NONE -1
#define PHASE_SEND 0
#define PHASE_CMD 1
#define PHASE_DATA 2

#define CMD_UNKNOWN -1
#define CMD_NONE 0
#define CMD_HELO 1
#define CMD_MAIL 2
#define CMD_RCPT 3
#define CMD_DATA 4
#define CMD_NOOP 5
#define CMD_RSET 6
#define CMD_QUIT 7
#define CMD_DATA2 8
#define CMD_RCPTE 31
#define CMD_DATAEND 32
#define CMD_EHLO 9

#define MIME_7BIT 0
#define MIME_8BIT 1
#define MIME_BINARY 2
#define MIME_QUOTED 3
#define MIME_BASE64 4


#define SPAM_OK           0
#define SPAM_NotDefined   1
#define SPAM_Error430   430
#define SPAM_Error570   570

#define SMTP_Relay_Port       25
#define SMTP_Incomming_Port 5225
#define SMTP_TimeOut 30

#define SEQ_ESCAPE "()<>,;:\"/[]?"
#define SEQ_QP     "()<>,@;:\"/[]?."
#define EQP_LENGTH(lii) (lii*3+((lii*3)/20)+1)



#define SMTP_JID_ICHS  "\"'<> \t,"

#define NS_COMMANDS    "http://jabber.org/protocol/commands"
#define NS_STATS       "http://jabber.org/protocol/stats"
#define NS_ADDRESS     "http://jabber.org/protocol/address"
#define NS_DISCO_INFO  "http://jabber.org/protocol/disco#info"
#define NS_DISCO_ITEMS "http://jabber.org/protocol/disco#items"
#define NS_CAPS        "http://jabber.org/protocol/caps"
#define NS_XHTML_IM    "http://jabber.org/protocol/xhtml-im"
#define NS_DATA        "jabber:x:data"
#define NS_XMPP_PING   "urn:xmpp:ping"
#define NS_IQ_RPC      "jabber:iq:rpc"
#define NS_EML         "xmpp:x:eml"


#define SMTP_BACKUPSMTP_FOLDER         "./spool/smtp/smtp-b"
#define SMTP_BACKUPJABBER_FOLDER       "./spool/smtp/jabber-b"
#define SMTP_OFFLINESMTP_FOLDER        "./spool/smtp/smtp-o"
#define SMTP_OFFLINEJABBER_FOLDER      "./spool/smtp/jabber-o"
#define SMTP_CORETMP_FOLDER            "./spool/smtp/tmp"
#define SMTP_JABSTATS_FOLDER          "./smtp/jabstats"


#define SMTP_STATISTICS_FILE          "./spool/statistics.xml"
#define SMTP_RESOURCE_FILE            "./smtp/resources.xml"
#define SMTP_ROSTER_FOLDER            "./spool/smtp/roster"
#define SMTP_CONFIG_FILE              "./smpt/config.xml"
#define SMTP_CONFIGR_FILE             "./smpt/configr.xml"

#define SMTP_DEFAULT_RELAY             "localhost"


#define SMTP_PGP_ATTACH 0
#define SMTP_PGP_MIME   1
#define SMTP_PGP_NOMIME 2


#define SMTP_PGP_MESSAGE         "PGP MESSAGE"
#define SMTP_PGP_SIGNATURE       "PGP SIGNATURE"
#define SMTP_PGP_SIGNED_MESSAGE  "-----BEGIN PGP SIGNED MESSAGE-----"
#define SMTP_PGP_BEGIN           "-----BEGIN"
#define SMTP_PGP_END             "-----END"

#define SMTP_PGP_sBEGIN          "BEGIN"
#define SMTP_PGP_sEND            "END"
#define SMTP_PGP_MESSAGE_BEGIN   "-----BEGIN PGP MESSAGE-----"
#define SMTP_PGP_SIGNATURE_BEGIN "-----BEGIN PGP SIGNATURE-----"
#define SMTP_PGP_MESSAGE_END     "-----END PGP MESSAGE-----"
#define SMTP_PGP_SIGNATURE_END   "-----END PGP SIGNATURE-----"


#define SMTP_IN_DELIVER_ALL    0
#define SMTP_IN_DELIVER_GLOBAL 1
#define SMTP_IN_DELIVER_USER   2


#define SMTP_ADMIN_JID   0
#define SMTP_ADMIN_EMAIL 1

#define SMTP_ADMIN_NS_JID       "smtp:admin:jid"
#define SMTP_ADMIN_NS_EMAIL     "smtp:admin:email"
#define SMTP_ADMIN_NS_INFOTRACK "smtp:admin:info_track"
#define SMTP_ADMIN_NS_CONFIG    "smtp:admin:config"
#define SMTP_ADMIN_NS_TRANSPORT "smtp:admin:transport"
#define SMTP_ADMIN_NS_ACCOUNT   "smtp:admin:account"
#define SMTP_ADMIN_NS_JABSTATS  "smtp:admin:jabstats"
#define SMTP_ADMIN_NS_LOG       "smtp:admin:log"

#define SMTP_CMDG_TRANSPORT "!transport"
#define SMTP_CMDG_CONFIG    "!config"
#define SMTP_CMDG_ACCOUNT   "!account"
#define SMTP_CMDG_CL        "!cl"
#define SMTP_CMDG_LOG       "!log"
#define SMTP_CMDG_JABSTATS  "!jabstats"


#define SMTP_CODE_220 220
#define SMTP_CODE_221 221
#define SMTP_CODE_250 250
#define SMTP_CODE_251 251
#define SMTP_CODE_354 354
#define SMTP_CODE_404 404
#define SMTP_CODE_500 500
#define SMTP_CODE_502 502
#define SMTP_CODE_503 503
#define SMTP_CODE_504 504
#define SMTP_CODE_550 550
#define SMTP_CODE_554 554
#define SMTP_CODE_553 553
#define SMTP_CODE_552 552

#define SMTP_DB
//#define SMTP_DEBUG log_notice
//#define SMTP_ZONE "smtp"
#define SMTP_DEBUG log_debug
#define SMTP_ZONE ZONE


#define SMTP_IN_EMAIL   0
#define SMTP_IN_OFFLINE 1


#define SMTP_QUEUE_X   0
#define SMTP_QUEUE_CB  1


#define SMTP_PHOTO "/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAAQABADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwC3o3guDU7C3uJr2SAzrlAEDBsdRnjng8en44i1rwlb6XDO0V5JO0Kbn+QKF9Bn19vT6jNSw8UyWdhFayQGZYgQh8zbt9xxwffqO2OcsvvEn2qylt47YxeaMOxk3bvc5HJ968iTzR1UoqVr91a1/v28jkX9lex1cb2873sf/9k="


#define SMTP_SITA_N 0
#define SMTP_SITA_M 1
#define SMTP_SITA_C 2
#define SMTP_SITA_P 3

#define SMTP_ACCOUNT_ALL 0
#define SMTP_ACCOUNT_PAID 1

#define SMTP_MEMORY_CORE PM_MEMORY_CORE
#define SMTP_MEMORY_DATA PM_MEMORY_DATA
#define SMTP_MEMORY_ALL  PM_MEMORY_ALL
#define SMTP_MEMORY_JID  3

#define SMTP_SETTINGS_DEFAULT  0
#define SMTP_SETTINGS_ACCOUNT  1
#define SMTP_SETTINGS_CONTACT  2

typedef struct smtp_jcmd_struc
{
struct smtp_jcmd_struc *next; /* next item */
void *Data;
char *cSessionID;
int iLevel,iMaxLevel;
pool p;
} *smtp_jcmdq,_smtp_jcmdq;



// Spamlist a AutoSignature - jednotliv dky jsou oddleny pomoc \n
typedef struct smtp_roster_data_struc
{
char *cJID,*J2S_RTName,*J2S_RTAddr,*J2S_SRSeparator,*J2S_SRText,*S2J_SRSeparator,*S2J_SRText,*Spamlist,*AutoSignature;
int UseGlobalSettings,Attachments,PGPJabberToMIME,PGPToJabbernonMIMETox,S2J_AllAreSPAM,J2S_RTMode,
    J2S_SRMode,S2J_SRMode;

struct smtp_roster_data_struc *next; /* next item*/
struct smtp_roster_data_struc *last; /* last item*/
pool p;

xmlnode oData;
} *smtp_rjid,_smtp_rjid;

/*
File->next (File)
  ->item->next (item->item)



*/

typedef struct smtp_roster_struc
{
struct smtp_roster_struc *next; /* next item - file*/
struct smtp_roster_struc *last; /* last item - file*/
char *cGroup; // first char (two bytes)
smtp_rjid item; // first item (roster) of list
pool p;
} *smtp_rjids,_smtp_rjids;


typedef struct smtp_contacts_struc
{
struct smtp_contacts_struc *next; /* next item */
struct smtp_contacts_struc *last; /* last item */
xmlnode item;
xmlnode offitem;
char *cJID;
pool p;
int iLogin;
} *smtp_cjid,_smtp_cjid;



typedef struct smtp_stats_struct
{

   // elapsed
   int JabberMessages,JabberMessagesOut,JabberMessagesOutError,
       SMTPCommandUnknown,SMTPMessages,
	   SMTPProcessed,SMTPNRRecipient,SMTPBadRecipient,SMTPBlockedByRecipient,
       SMTPSpam, CoreAccounts,SMTPMaxSize,SMTPNoProcess,SMTPBouncy,SMTPNoRecipient,SMTPSpammers,
       XMPPInAll, XMPPInMessage, XMPPInPresence, XMPPInSN10, XMPPInIQ, XMPPInUnknown,
       XMPPOutAll, XMPPOutMessage, XMPPOutPresence, XMPPOutSN10, XMPPOutIQ, XMPPOutUnknown;

   int Start;
   char *StartLastDatetime;

   // Core
   int _JabberMessages, _JabberMessagesOut, _JabberMessagesOutError,
       _SMTPCommandUnknown,_SMTPMessages,_SMTPProcessed,_SMTPNRRecipient,_SMTPBadRecipient,
       _SMTPSpam,_CoreContacts,_CoreAccounts,_SMTPMaxSize,_SMTPNoProcess,_SMTPBouncy,
       _SMTPNoRecipient,_SMTPSpammers,_SMTPBlockedByRecipient,
       _XMPPInAll, _XMPPInMessage, _XMPPInPresence, _XMPPInSN10, _XMPPInIQ, _XMPPInUnknown,
       _XMPPOutAll, _XMPPOutMessage, _XMPPOutPresence, _XMPPOutSN10, _XMPPOutIQ, _XMPPOutUnknown;


} *smtp_stats, _smtp_stats;


/* smtp parser instance */
typedef struct smtpi_struct
{
   instance i;
   char *server; /* our master server address, if any */
   char *relay; /* the smtp relay delivering our messages for us */
   int relayport; /* the smtp relay port */
//   int timeout; /* how long to wait for an incoming request */
   char *me; /* our default smtp hostname */
   char *met; /* our default smtp transport JID */
   int SMTP_Open; /* if this component is wide open */
   int Jabber_Open; /* if this component is wide open */
   int Spamer_Open; /* if this component is wide open */
   char *spamcheck;
   int jep0033; /* JEP-0033: Extended Stanza Addressing, support */ 
   int timeout; /* timeout for receiving email */ 

   int iMaxSize,iFastProcessingBufferSize;

   xmlnode config;
   xmlnode configr;
   xmlnode status;
   xdbcache xc;

   int tmpBackupJabber,tmpBackupSMTP;
   int tmpOfflineJabber,tmpOfflineSMTP;
   int tmpCoreTmp;

   char *config_file; /* config file name */
   char *configr_file; /* runtime config file name */
   char *stat_file; /* Statistics file name */
   char *res_file; /* Resources file name */
   char *jabstats_folder; /* Jabber stats folder */
   char *roster_folder; /* Roster folder */

   char *jabber_backup;
   char *jabber_offline;
   char *smtp_backup;
   char *smtp_offline;
   char *core_tmp;

   char *DefaultLang; /* Default language */

   xmlnode jabstats; /* jabstats node */
   xmlnode memtest; /* memtes node */
   xmlnode resources; /* resources node */

   smtp_rjids roster; /* roster group root item  */

   smtp_jcmdq qcmd;
   smtp_cjid ContactList;
   smtp_stats Stats; // statistika
   PMI_struc pools;
   HJPMI_struc hooks;

} *smtpi, _smtpi;

/* our 'session' data  - jabber to smtp*/
typedef struct smtps_struct
{
   int phase, timer, lastcmd, iStatus, ircpt,mio_status;
   char *from;
   char *buffer;
   char *host;
   char *cStatus;
   char *cLastOut;
   jid rcpt;
   mio m;
   pool p;
   xmlnode x, oJID, oAD;
   
   int toPGPMIME,Advertising,SRMode;
   char *SRSeparator, *SRText, *lang;
   
   jpacket jp; // incomming jabber packet
   instance i;
  
} *smtps, _smtps;



/* our 'session' data - smtp to jabber*/
typedef struct smptsi_rcp_struc
{ 
   jid rcpt;
   xmlnode oJID;
   int iErr,Advertising,nonMIME2x,Attachments,UseGlobalSettings,SRMode,
       S2J_AllAreSPAM,iForwarde,_iForwarde,iSpammer,_iSpammer,_iGSpammer,OutputMode;
   char *SRSeparator, *SRText, *smtpaddr;

   struct smptsi_rcp_struc *next; /* for lists of recipients */
} *smptsi_rcp,_smptsi_rcp;


typedef struct smtpsi_struct
{
   int phase, lastcmd, iSize, iEnd ,iProcessMail,iType,iSizeMF,iFastProcessing,iDCRLF,iDOTAdd ;
   time_t iTimerS, iTimerN,iThreadData;
   char *from;
   char *fromEx;
   char *jidfrom;
   char *buffer;
   char *host;
   char *listcc;
   char *listto;
   char *Body;
   char *MBody;
   char *cStatus;
   char *lang;
   char *cFile;
   char *cThreadData;

   smptsi_rcp rcpt;
   smptsi_rcp rcptFD;

   mio m;
   pool p;
   xmlnode x,oMsg;
   pool  pMessage;
   spool cMessage;
   int iPGP;
   xmlnode oAD;

   mtq  q;

} *smtpsi, _smtpsi;


/* our 'session' data */
typedef struct smtp_param
{
   jpacket jp; // incomming jabber packet
   dpacket dp; // incomming jabber delivery packet
   pool tmppool;
   char *lang;
   mtq  q;

   instance i;
} *smtpp, _smtpp;

typedef struct smtpsx_struct
{
 smtpp par;
 smtps so;
 pool p;
 int state;
 char *cBFile;
 void *gmCB;
 void *gmArg;
 void *gmCBF;
 void *gmArgF;
} *smtpsx, _smtpsx;


/* context for MIME decoding */
typedef struct mimectx_struct
{
   int mimeUsed;
   int mimeEncoding;
   char *mimeCharset;
} *mimectx, _mimectx;


typedef struct smtp_jabber_queue_struc_x
{
xmlnode x; // xmlnode
} *smtp_jq_x,_smtp_jq_x;

typedef struct smtp_jabber_queue_struc_cb
{
void *cb; 
void *arg; 
} *smtp_jq_cb,_smtp_jq_cb;

typedef struct smtp_jabber_queue_struc
{
struct smtp_jabber_queue_struc *next; /* next queue item */
void *Data;
int iType;

} *smtp_jq,_smtp_jq;




// smtp.c
smtps smtp_new_out(mio m);
smtpsi smtp_new_in(pool p,mio m);
void smtp_reset_in(smtpsi si);
smtpp smtp_param_i(pool p,instance i);
void smtp_SendInfoToAdmin(const char *lcMSG, int liType);
void smtp_SendInfoToAny(const char *lcFrom,const char *lcTo, const char *lcMSG, int liType, xmlnode loError);
smptsi_rcp smtp_NewRecipient(pool p,jid ojid);
smptsi_rcp smtp_AppendRcpt(smptsi_rcp a, smptsi_rcp b);
void smtp_SetGSpammerRcpt(smptsi_rcp a);
jid smtp_2mx(jid id);
jid smtp_mx2(jid id);

typedef void (*smtp_queue_cb)(void *arg);
typedef void (*smtp_j2s_cb)(smtps so, void *arg);

smtp_jq smtp_NewQueueItem(pool p, int liType);
smtp_jq smtp_AppendQueueItem(smtp_jq a, smtp_jq b);
void smtp_FlushQueue(instance i, smtp_jq item);
void smtp_ClearQueue(smtp_jq item);

smtp_jcmdq smtp_CmdNew();
smtp_jcmdq smtp_CmdAppend(smtp_jcmdq b);
smtp_jcmdq smtp_CmdGet(char *lcSessionID);
void smtp_CmdDel(char *lcSessionID);
int smtp_CmdGetMem(int liType,char *lcSessionID);

void smtp_StatsSave();
void smtp_ConfigSave();


// roster.h
int smtp_online_add_item( char *lcFrom, char *lcTo);
int smtp_online_remove_item( char *lcFrom, char *lcTo);

xmlnode smtp_online_get_item(char *lcFrom, char *lcTo, int liDefault);
void smtp_online_set_item(char *lcFrom, xmlnode loTo);

xmlnode SMTP_PieceSettings(char *lcFrom , char *lcTo, int *liType);

smtp_cjid smtp_cjidNew(xmlnode loNode,char *lcJID);
smtp_cjid smtp_cjidGet(char *lcJID);
smtp_cjid smtp_cjidAppend(smtp_cjid b);
void smtp_cjidDel(char *lcJID);
int smtp_cjidGetCount(int liFlag);
int smtp_cjidGetContactsCount();
int SMTP_GetItemMemCL(int liType, char *lcJID);

void SMTP_SetItemRoster(xmlnode loRI,int liSave);
xmlnode SMTP_GetItemRoster(char *lcJID, int liDefault);
void SMTP_DropItemRoster(char *lcJID);
int SMTP_TestItemRoster(char *lcJID);
int SMTP_GetItemCountRoster(int liType);
int SMTP_GetItemMemRoster(int liType, char *lcJID);


// in.c
void smtp_in_read(mio m, int state, void *arg, char *buffer,int bufsz);
void smtp_in_status(smtpsi si, int liStatus, char *data);
void smtp_in_offline_message(xmlnode loMSG, char *lcOFile);
smtps smtp_in_recipient_cb(smtps so, void *lugmArg);
smtps smtp_in_recipient_cbf(smtps so, void *lugmArg);
smtps smtp_in_replytosmtp_cb(smtps so, void *lugmArg);
smtps smtp_in_replytosmtp_cbf(smtps so, void *lugmArg);
result smtp_in_daemon(void *arg);

// in_spam.c
int smtp_in_spam(smtpsi si, char *msg);


// out.c
result smtp_out_packets(instance i, dpacket p, void *arg);

// out_iq.c
int smtp_out_packets_iq(smtpp par, char *lcType);
void smtp_out_packets_iq_xep0033(void *CBFA, jpacket loJP);

// out_iq_register.c
int smtp_out_packets_iq_register(smtpp par, char *type);
void smtp_opiqr_SaveToJID(xmlnode xData,xmlnode loJID);
void smtp_opiqr_FillDataFromJID(pool p, const char *lcGroup,xmlnode xData,xmlnode loJID,char *lcLang);

// out_iq_vcard.c
int smtp_out_packets_iq_vcard(smtpp par, char *type);

// out_iq_gateway.c
int smtp_out_packets_iq_gateway(smtpp par, char *type);

// out_iq_time.c
int smtp_out_packets_iq_time(smtpp par, char *type);

// out_iq_version.c
int smtp_out_packets_iq_version(smtpp par, char *type);

// out_iq_di.c
int smtp_out_packets_iq_di(smtpp par, char *type);

// out_iq_stats.c
int smtp_out_packets_iq_stats(smtpp par, char *type);
void smtp_stats_in(xmlnode x);
void smtp_stats_out(xmlnode x);

// out_presence.c
int smtp_out_packets_presence(smtpp par, char *lcType);

// out_mesage.c
int smtp_out_packets_message(smtpp par, char *lcType);
void smtp_out_offline_message(xmlnode loMSG);
void smtp_out_process_message(smtpp par, void *luCB, void *luArg, void *luCBF, void *luArgF);

// out_admin.c
int smtp_admin_message(smtpp par, char *lcType);
int _smtp_opm_check_JID(char *lcJID,const char *lcNS);
int _smtp_opmadmin_getcntfolder(char *lcFLD,int liOld);
char *_smtp_opmadmin_getfolder(pool p, char *lcFLD);


// out_S10N.c
int smtp_out_packets_S10N(smtpp par, char *lcType);

// out_iq_di_ping.c
int smtp_out_packets_iq_ping(smtpp par, char *type);

// out_iq_di_viprpc.c
int smtp_out_packets_iq_viprpc(smtpp par, char *type);


// out_iq_vcard_jid.c
int smtp_out_packets_iq_vcard_jid(smtpp par, char *type);

// out_iq_di_jid.c
int smtp_out_packets_iq_di_jid(smtpp par, char *type);



// offline.c
result smtp_offline_jdaemon(void *arg);
result smtp_offline_sdaemon(void *arg);

// paid.c
result smtp_paid_daemon(void *arg);
int smtp_ispaid(char *lcJID, xmlnode loJID);

// utils.c
char *smtp_alltrim(char *lcChar);
char *smtp_2ws(char *lcChar);
char *smtp_lgstrim(char *lcChar);
char *smtp_strcasestr(char *lcWhere,char *lcWhat);
char *smtp_CMonth(int liMonth);
char *smtp_itoa(pool p, int liNumber);
char *smtp_pttoa(pool p,void *liPointer);
xmlnode out_SetReply(xmlnode loNew, xmlnode loOld);
void smtp_ReplyError(instance i, jpacket loOrig, const char *lcNodeName, const char *lcBody, int liError);
char *smtp_GetDateTime(char *lcDateTime);
char *smtp_GetFolderFromFile(char *lcFolder);
int smtp_CreateFolder(char *lcFolder);
char *smtp_rc_GetString(pool p,char *lcLang, int liID);
char *smtp_GetSMTPAddress(char *lcJID);
char *smtp_GetJID(pool p,char *lcJID);
char *smtp_ToUTF8(pool p, char *lcText,const char *charmap);
void fromQP(char *string, void *byteStream);
void toQP(char *string, void *byteStream, int liSoftLines, const char *lcSpec);
void toEscape(char *string, void *byteStream, const char *lcSpec);
void fromEscape(char *string, void *byteStream);
char *smtp_getword(char **lcChar, char *lcSep, char *lcMax);
int smtp_check_list(char *lcItem, xmlnode loItem, int *liFound);

// jabstats.c
void jabstats_add(jpacket jp);

//void smtp_TEST(smtpp par, jpacket loOrig);
